/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.cache.ehcache;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.anyline.cache.CacheElement;
import org.anyline.cache.CacheProvider;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="anyline.cache.provider")
public class EHCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(EHCacheProvider.class);
    private CacheManager manager = null;
    private HashSet<String> channels = new HashSet();
    private Hashtable<String, Long> reflushFlag = new Hashtable();

    public int getLvl() {
        return 1;
    }

    public static InputStream getConfigFile() throws Exception {
        File file = null;
        String path = ConfigTable.getString((String)"EHCACHE_CONFIG_PATH");
        log.info("[\u68c0\u6d4behcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
        if (null != path && (file = new File(path)).exists()) {
            log.info("[\u52a0\u8f7dehcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
            return new FileInputStream(file);
        }
        if ("jar".equals(ConfigTable.getPackageType())) {
            path = FileUtil.merge((String[])new String[]{ConfigTable.getRoot(), "config", "ehcache.xml"});
            log.info("[\u68c0\u6d4behcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
            file = new File(path);
            if (file.exists()) {
                log.info("[\u52a0\u8f7dehcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
                return new FileInputStream(file);
            }
            path = FileUtil.merge((String[])new String[]{ConfigTable.getRoot(), "ehcache.xml"});
            log.info("[\u68c0\u6d4behcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
            file = new File(path);
            if (file.exists()) {
                log.info("[\u52a0\u8f7dehcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
                return new FileInputStream(file);
            }
            path = FileUtil.merge((String[])new String[]{ConfigTable.getClassPath(), "ehcache.xml"});
            log.info("[\u68c0\u6d4behcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
            file = new File(path);
            if (file.exists()) {
                log.info("[\u52a0\u8f7dehcache\u914d\u7f6e\u6587\u4ef6][path={}]", (Object)path);
                return new FileInputStream(file);
            }
            InputStream in = ConfigTable.class.getClassLoader().getResourceAsStream("/ehcache.xml");
            return in;
        }
        return null;
    }

    public CacheManager manager() {
        long fr = System.currentTimeMillis();
        if (null == this.manager) {
            try {
                String[] names;
                InputStream in = EHCacheProvider.getConfigFile();
                this.manager = null != in ? CacheManager.create((InputStream)in) : CacheManager.create();
                for (String name : names = this.manager.getCacheNames()) {
                    this.channels.add(name);
                }
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.info("[\u52a0\u8f7dehcache\u914d\u7f6e\u6587\u4ef6][\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - fr));
                    for (String name : this.manager.getCacheNames()) {
                        log.info("[\u89e3\u6790ehcache\u914d\u7f6e\u6587\u4ef6] [name:{}]", (Object)name);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.manager;
    }

    public Cache getCache(String channel) {
        CacheManager manager = this.manager();
        Cache cache = manager.getCache(channel);
        if (null == cache) {
            manager.addCache(channel);
        }
        cache = manager.getCache(channel);
        return cache;
    }

    public List<String> getCacheNames() {
        ArrayList<String> names = new ArrayList<String>();
        CacheManager manager = this.manager();
        for (String name : manager.getCacheNames()) {
            names.add(name);
        }
        return names;
    }

    public List<Cache> getCaches() {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        CacheManager manager = this.manager();
        for (String name : manager.getCacheNames()) {
            caches.add(manager.getCache(name));
        }
        return caches;
    }

    public CacheElement get(String channel, String key) {
        CacheElement result = new CacheElement();
        Element element = this.getElement(channel, key);
        if (null != element) {
            result.setCreateTime(element.getCreationTime());
            result.setValue(element.getObjectValue());
            result.setExpires(element.getTimeToLive());
        }
        return result;
    }

    public Element getElement(String channel, String key) {
        Element result = null;
        long fr = System.currentTimeMillis();
        Cache cache = this.getCache(channel);
        if (null != cache) {
            result = cache.get((Serializable)((Object)key));
            if (null == result) {
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.warn("[\u7f13\u5b58\u4e0d\u5b58\u5728][cnannel:{}][key:{}][\u751f\u5b58:-1/{}]", new Object[]{channel, key, cache.getCacheConfiguration().getTimeToLiveSeconds()});
                }
                return null;
            }
            if (result.isExpired()) {
                if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                    log.warn("[\u7f13\u5b58\u6570\u636e\u63d0\u53d6\u6210\u529f\u4f46\u5df2\u8fc7\u671f][\u8017\u65f6:{}][cnannel:{}][key:{}][\u547d\u4e2d:{}][\u751f\u5b58:{}/{}]", new Object[]{System.currentTimeMillis() - fr, channel, key, result.getHitCount(), (System.currentTimeMillis() - result.getCreationTime()) / 1000L, result.getTimeToLive()});
                }
                result = null;
            } else if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
                log.info("[\u7f13\u5b58\u6570\u636e\u63d0\u53d6\u6210\u529f\u5e76\u6709\u6548][\u8017\u65f6:{}][cnannel:{}][key:{}][\u547d\u4e2d:{}][\u751f\u5b58:{}/{}]", new Object[]{System.currentTimeMillis() - fr, channel, key, result.getHitCount(), (System.currentTimeMillis() - result.getCreationTime()) / 1000L, result.getTimeToLive()});
            }
        }
        return result;
    }

    public void put(String channel, String key, Object value) {
        Element element = new Element((Object)key, value);
        this.put(channel, element);
    }

    public void put(String channel, Element element) {
        Cache cache = this.getCache(channel);
        if (null != cache) {
            cache.put(element);
            if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
                log.info("[\u5b58\u50a8\u7f13\u5b58\u6570\u636e][channel:{}][key:{}][\u751f\u5b58:0/{}]", new Object[]{channel, element.getObjectKey(), cache.getCacheConfiguration().getTimeToLiveSeconds()});
            }
        }
    }

    public boolean remove(String channel, String key) {
        boolean result = true;
        try {
            Cache cache = this.getCache(channel);
            if (null != cache) {
                cache.remove((Serializable)((Object)key));
            }
            if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
                log.info("[\u5220\u9664\u7f13\u5b58\u6570\u636e] [channel:{}][key:{}]", (Object)channel, (Object)key);
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean clear(String channel) {
        boolean result = true;
        try {
            CacheManager manager = this.manager();
            manager.removeCache(channel);
            if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
                log.info("[\u6e05\u7a7a\u7f13\u5b58\u6570\u636e] [channel:{}]", (Object)channel);
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean clears() {
        this.manager().clearAll();
        return true;
    }

    public HashSet<String> channels() {
        return this.channels;
    }
}

