/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.baidu.map.util;

import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.anyline.baidu.map.util.BaiduMapConfig;
import org.anyline.client.map.AbstractMapClient;
import org.anyline.client.map.MapClient;
import org.anyline.entity.Coordinate;
import org.anyline.entity.DataRow;
import org.anyline.entity.SRS;
import org.anyline.exception.AnylineException;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.encrypt.MD5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduMapClient
extends AbstractMapClient
implements MapClient {
    private static Logger log = LoggerFactory.getLogger(BaiduMapClient.class);
    private static final String HOST = "https://api.map.baidu.com";
    public BaiduMapConfig config = null;
    private static Hashtable<String, BaiduMapClient> instances = new Hashtable();

    public static Hashtable<String, BaiduMapClient> getInstances() {
        return instances;
    }

    public BaiduMapConfig getConfig() {
        return this.config;
    }

    public static BaiduMapClient getInstance() {
        return BaiduMapClient.getInstance("default");
    }

    public static BaiduMapClient getInstance(String key) {
        BaiduMapConfig config;
        BaiduMapClient client;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (client = instances.get(key)) && null != (config = BaiduMapConfig.getInstance(key))) {
            client = new BaiduMapClient();
            client.config = config;
            instances.put(key, client);
        }
        return client;
    }

    public Coordinate ip(String ip) {
        return null;
    }

    public Coordinate geo(String address, String city) {
        DataRow location;
        String api = "/geocoding/v3/";
        Coordinate coordinate = new Coordinate();
        coordinate.setAddress(address);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("address", address);
        params.put("output", "json");
        DataRow row = this.api(api, params);
        if (null != row && null != (location = row.getRow(new String[]{"result", "location"}))) {
            coordinate.setLng(location.getString("lng"));
            coordinate.setLat(location.getString("lat"));
            coordinate.setSuccess(true);
        }
        if (null != coordinate) {
            coordinate.correct();
        }
        return coordinate;
    }

    public Coordinate regeo(Coordinate coordinate) {
        String api = "/reverse_geocoding/v3/";
        SRS _type = coordinate.getSrs();
        Double _lng = coordinate.getLng();
        Double _lat = coordinate.getLat();
        coordinate.convert(SRS.BD09LL);
        coordinate.setSuccess(false);
        coordinate.setLng(_lng);
        coordinate.setLat(_lat);
        coordinate.setSrs(_type);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("location", coordinate.getLat() + "," + coordinate.getLng());
        params.put("extensions_town", "true");
        params.put("output", "json");
        DataRow row = this.api(api, params);
        if (null != row) {
            coordinate.setAddress(row.getString("formatted_address"));
            DataRow adr = row.getRow(new String[]{"result", "addressComponent"});
            if (null != adr) {
                String adcode = adr.getString("adcode");
                String provinceCode = adcode.substring(0, 2);
                String cityCode = adcode.substring(0, 4);
                coordinate.setProvinceCode(provinceCode);
                coordinate.setProvinceName(adr.getString("province"));
                coordinate.setCityCode(cityCode);
                coordinate.setCityName(adr.getString("city"));
                coordinate.setCountyName(adr.getString("district"));
                coordinate.setCountyCode(adr.getString("adcode"));
                coordinate.setTownCode(adr.getString("town_code"));
                coordinate.setTownName(adr.getString("town"));
                String street = adr.getString("street");
                coordinate.setStreet(street);
                String number = adr.getString("street_number");
                if (null != number && null != street) {
                    number = number.replace(street, "");
                }
                coordinate.setStreet(street);
                coordinate.setStreetNumber(number);
                coordinate.setSuccess(true);
            }
        }
        if (null != coordinate) {
            coordinate.correct();
        }
        return coordinate;
    }

    private DataRow api(String api, Map<String, Object> params) {
        String txt;
        DataRow row = null;
        this.sign(api, params);
        HttpResponse response = HttpUtil.get((String)(HOST + api), (String)"UTF-8", params);
        int status = response.getStatus();
        if (status == 200 && null == (row = DataRow.parseJson((String)(txt = response.getText()))) && (status = row.getInt("status", Integer.valueOf(-1)).intValue()) != 0) {
            log.warn("[{}][\u6267\u884c\u5931\u8d25][status:{}][info:{}]", new Object[]{api, status, row.getString("message")});
            log.warn("[{}][response:{}]", (Object)api, (Object)txt);
            if ("302".equals(status)) {
                throw new AnylineException("API_OVER_LIMIT", "\u8bbf\u95ee\u5df2\u8d85\u51fa\u65e5\u8bbf\u95ee\u91cf");
            }
            if ("401".equals(status) || "402".equals(status)) {
                try {
                    log.warn("\u5e76\u53d1\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650,sleep 50 ...");
                    Thread.sleep(50L);
                    this.api(api, params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new AnylineException(status, row.getString("message"));
            }
        }
        return row;
    }

    public void sign(String api, Map<String, Object> params) {
        params.put("ak", this.config.AK);
        try {
            for (String key : params.keySet()) {
                String value = (String)params.get(key);
                value = URLEncoder.encode(value, "UTF-8");
                params.put(key, value);
            }
            Object str = api + "?" + BeanUtil.map2string(params) + this.config.SK;
            str = URLEncoder.encode((String)str, "UTF-8");
            params.put("sn", MD5Util.crypto((String)str));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Hashtable<String, AnylineConfig> configs = BaiduMapConfig.getInstances();
        for (String key : configs.keySet()) {
            instances.put(key, BaiduMapClient.getInstance(key));
        }
    }
}

