/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.baidu.map.util;

import java.util.Hashtable;
import org.anyline.baidu.map.util.BaiduMapClient;
import org.anyline.entity.DataRow;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class BaiduMapConfig
extends AnylineConfig {
    public static String CONFIG_NAME = "anyline-baidu-map.xml";
    private static Hashtable<String, AnylineConfig> instances = new Hashtable();
    public static String DEFAULT_AK = "";
    public static String DEFAULT_SK = "";
    public String AK = DEFAULT_AK;
    public String SK = DEFAULT_SK;

    public static Hashtable<String, AnylineConfig> getInstances() {
        return instances;
    }

    public static void parse(String content) {
        BaiduMapConfig.parse(BaiduMapConfig.class, (String)content, instances, (String[])compatibles);
    }

    public static void init() {
        BaiduMapConfig.load();
    }

    public static BaiduMapConfig getInstance() {
        return BaiduMapConfig.getInstance("default");
    }

    public static BaiduMapConfig getInstance(String key) {
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            BaiduMapConfig.load();
        }
        return (BaiduMapConfig)instances.get(key);
    }

    private static synchronized void load() {
        BaiduMapConfig.load(instances, BaiduMapConfig.class, (String)CONFIG_NAME, (String[])new String[0]);
        lastLoadTime = System.currentTimeMillis();
    }

    private static void debug() {
    }

    public static BaiduMapConfig register(String instance, DataRow row) {
        BaiduMapConfig config = (BaiduMapConfig)BaiduMapConfig.parse(BaiduMapConfig.class, (String)instance, (DataRow)row, instances, (String[])compatibles);
        BaiduMapClient.getInstance(instance);
        return config;
    }

    public static BaiduMapConfig register(DataRow row) {
        return BaiduMapConfig.register("default", row);
    }

    public static BaiduMapConfig register(String instance, String ak, String sk) {
        DataRow row = new DataRow();
        row.put("AK", (Object)ak);
        row.put("SK", (Object)sk);
        return BaiduMapConfig.register(instance, row);
    }

    public static BaiduMapConfig register(String ak, String sk) {
        return BaiduMapConfig.register("default", ak, sk);
    }

    static {
        BaiduMapConfig.init();
        BaiduMapConfig.debug();
    }
}

