/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.aliyun.sms.util;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.AddSmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.AddSmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.DeleteSmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.DeleteSmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.ModifySmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.ModifySmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsRequest;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsResponse;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsResponseBody;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateListRequest;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateListResponse;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateListResponseBody;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateResponseBody;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.aliyun.sms.util.SMSConfig;
import org.anyline.aliyun.sms.util.SMSTemplate;
import org.anyline.sms.entity.SMSResult;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSUtil {
    private static final Logger log = LoggerFactory.getLogger(SMSUtil.class);
    private SMSConfig config = null;
    private Client client;
    private static Hashtable<String, SMSUtil> instances = new Hashtable();
    public Template template = new Template();
    static final String product = "Dysmsapi";
    static final String endpoint = "dysmsapi.aliyuncs.com";

    public static SMSUtil getInstance() {
        return SMSUtil.getInstance("default");
    }

    public static SMSUtil getInstance(String key) {
        SMSConfig config;
        SMSUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key)) && null != (config = SMSConfig.getInstance(key))) {
            util = new SMSUtil();
            util.config = config;
            try {
                Config cfg = new Config();
                cfg.setAccessKeyId(config.ACCESS_KEY);
                cfg.setAccessKeySecret(config.ACCESS_SECRET);
                cfg.endpoint = endpoint;
                util.client = new Client(cfg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            instances.put(key, util);
        }
        return util;
    }

    public SMSResult send(String sign, String template, String extend, String out, String mobile, Map<String, String> params) {
        SMSResult result = new SMSResult();
        try {
            if (BasicUtil.isEmpty((Object)sign)) {
                sign = this.config.SIGN;
            }
            SendSmsRequest request = new SendSmsRequest().setSignName(sign).setTemplateCode(template).setPhoneNumbers(mobile).setTemplateParam(BeanUtil.map2json(params));
            if (BasicUtil.isNotEmpty((Object)extend)) {
                request.setSmsUpExtendCode(extend);
            }
            if (BasicUtil.isNotEmpty((Object)out)) {
                request.setOutId(out);
            }
            RuntimeOptions runtime = new RuntimeOptions();
            SendSmsResponse response = this.client.sendSmsWithOptions(request, runtime);
            result.setStatus(response.getStatusCode().intValue());
            SendSmsResponseBody body = response.getBody();
            result.setRequestId(body.getRequestId());
            result.setCode(body.getCode());
            result.setMsg(body.getMessage());
            result.setBiz(body.getBizId());
            result.setResult(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setResult(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public SMSResult send(String sign, String template, String mobile, Map<String, String> params) {
        return this.send(sign, template, null, null, mobile, params);
    }

    public SMSResult send(String sign, String template, String mobile, Object entity, List<String> keys) {
        return this.send(sign, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, String mobile, Object entity, String ... keys) {
        return this.send(sign, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Map<String, String> params) {
        String mobile = "";
        for (String item : mobiles) {
            if ("".equals(mobile)) {
                mobile = item;
                continue;
            }
            mobile = mobile + "," + item;
        }
        return this.send(sign, template, mobile, params);
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Object entity, List<String> keys) {
        return this.send(sign, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Object entity, String ... keys) {
        return this.send(sign, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String template, String mobile, Map<String, String> params) {
        return this.send(this.config.SIGN, template, mobile, params);
    }

    public SMSResult send(String template, String mobile, Object entity, List<String> keys) {
        return this.send(this.config.SIGN, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String template, String mobile, Object entity, String ... keys) {
        return this.send(this.config.SIGN, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String template, List<String> mobiles, Map<String, String> params) {
        return this.send(this.config.SIGN, template, mobiles, params);
    }

    public SMSResult send(String template, List<String> mobiles, Object entity, List<String> keys) {
        return this.send(this.config.SIGN, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String template, List<String> mobiles, Object entity, String ... keys) {
        return this.send(this.config.SIGN, template, mobiles, this.object2map(entity, keys));
    }

    public List<SMSResult> status(String mobile, String biz, String date, int vol, int page) throws RuntimeException {
        if (BasicUtil.isEmpty((Object)date)) {
            date = DateUtil.format((String)"yyyyMMdd");
        }
        ArrayList<SMSResult> results = new ArrayList<SMSResult>();
        QuerySendDetailsRequest query = new QuerySendDetailsRequest().setPhoneNumber(mobile).setSendDate(date).setPageSize(Long.valueOf(vol)).setCurrentPage(Long.valueOf(page));
        if (BasicUtil.isNotEmpty((Object)biz)) {
            query.setBizId(biz);
        }
        try {
            QuerySendDetailsResponse queryResp = this.client.querySendDetails(query);
            List list = queryResp.getBody().getSmsSendDetailDTOs().getSmsSendDetailDTO();
            for (QuerySendDetailsResponseBody.QuerySendDetailsResponseBodySmsSendDetailDTOsSmsSendDetailDTO item : list) {
                SMSResult result = new SMSResult();
                result.setStatus(item.getSendStatus().intValue());
                result.setContent(item.getContent());
                result.setCode(item.getErrCode());
                result.setMobile(item.getPhoneNum());
                result.setRequestId(queryResp.getBody().getRequestId());
                result.setOut(item.getOutId());
                result.setReceiveTime(item.getReceiveDate());
                result.setSendTime(item.getSendDate());
                result.setTemplate(item.getTemplateCode());
                results.add(result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return results;
    }

    public SMSResult status(String mobile, String biz, String date) {
        List<SMSResult> results = this.status(mobile, biz, date, 1, 1);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public SMSResult status(String mobile, String biz) {
        return this.status(mobile, biz, DateUtil.format((String)"yyyyMMdd"));
    }

    public SMSResult status(String mobile) {
        return this.status(mobile, null, DateUtil.format((String)"yyyyMMdd"));
    }

    public SMSConfig getConfig() {
        return this.config;
    }

    private Map<String, String> object2map(Object entity, List<String> keys) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != keys) {
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object value;
                String key;
                String field = key = iterator.next();
                if (key.contains(":")) {
                    String[] tmps = key.split(":");
                    key = tmps[0];
                    field = tmps[1];
                }
                if (null == (value = BeanUtil.getFieldValue((Object)entity, (String)field))) continue;
                params.put(key, value.toString());
            }
        }
        return params;
    }

    private Map<String, String> object2map(Object entity, String ... keys) {
        return this.object2map(entity, BeanUtil.array2list((Object[][])new String[][]{keys}));
    }

    public class Template {
        public String request(String name, int type, String content, String remark) throws RuntimeException {
            String code = null;
            AddSmsTemplateRequest req = new AddSmsTemplateRequest().setTemplateType(Integer.valueOf(type)).setTemplateName(name).setTemplateContent(content).setRemark(remark);
            try {
                AddSmsTemplateResponse response = SMSUtil.this.client.addSmsTemplate(req);
                if (!"OK".equalsIgnoreCase(response.getBody().getCode())) {
                    throw new RuntimeException("\u6a21\u677f\u7533\u8bf7\u5931\u8d25:" + response.getBody().getCode());
                }
                code = response.getBody().getTemplateCode();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return code;
        }

        public boolean update(String code, String name, int type, String content, String remark) throws RuntimeException {
            ModifySmsTemplateRequest req = new ModifySmsTemplateRequest().setTemplateType(Integer.valueOf(type)).setTemplateName(name).setTemplateCode(code).setTemplateContent(content).setRemark(remark);
            try {
                ModifySmsTemplateResponse resp = SMSUtil.this.client.modifySmsTemplate(req);
                if ("OK".equalsIgnoreCase(resp.getBody().getCode())) {
                    throw new Exception("\u4fee\u6539\u5931\u8d25:" + resp.getBody().getMessage());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public List<SMSTemplate> list() {
            List<SMSTemplate> list;
            ArrayList<SMSTemplate> templates = new ArrayList<SMSTemplate>();
            int page = 1;
            while (null != (list = this.list(page, 10)) && list.size() != 0) {
                templates.addAll(list);
                ++page;
            }
            return templates;
        }

        public List<SMSTemplate> list(SMSTemplate.STATUS status) {
            List<SMSTemplate> all = this.list();
            ArrayList<SMSTemplate> templates = new ArrayList<SMSTemplate>();
            for (SMSTemplate item : all) {
                if (!status.getCode().equals((Object)item.getStatus())) continue;
                templates.add(item);
            }
            return templates;
        }

        public List<SMSTemplate> list(boolean enable) {
            List<SMSTemplate> all = this.list();
            ArrayList<SMSTemplate> templates = new ArrayList<SMSTemplate>();
            for (SMSTemplate item : all) {
                if (enable) {
                    if (!SMSTemplate.STATUS.AUDIT_STATE_PASS.getCode().equals((Object)item.getStatus())) continue;
                    templates.add(item);
                    continue;
                }
                if (SMSTemplate.STATUS.AUDIT_STATE_PASS.getCode().equals((Object)item.getStatus())) continue;
                templates.add(item);
            }
            return templates;
        }

        public List<SMSTemplate> list(int page, int vol) throws RuntimeException {
            ArrayList<SMSTemplate> templates = new ArrayList<SMSTemplate>();
            QuerySmsTemplateListRequest req = new QuerySmsTemplateListRequest().setPageIndex(Integer.valueOf(page)).setPageSize(Integer.valueOf(vol));
            try {
                QuerySmsTemplateListResponse resp = SMSUtil.this.client.querySmsTemplateList(req);
                if (null == resp || 200 != resp.getStatusCode()) {
                    throw new RuntimeException("\u67e5\u8be2\u5931\u8d25:" + resp.getStatusCode());
                }
                QuerySmsTemplateListResponseBody body = resp.getBody();
                if (null == body || !"OK".equalsIgnoreCase(body.getCode())) {
                    throw new RuntimeException("\u67e5\u8be2\u5931\u8d25:" + body.getMessage());
                }
                List list = body.getSmsTemplateList();
                if (null == list) {
                    return templates;
                }
                for (QuerySmsTemplateListResponseBody.QuerySmsTemplateListResponseBodySmsTemplateList item : list) {
                    SMSTemplate template = new SMSTemplate();
                    template.setCode(item.getTemplateCode());
                    template.setContent(item.getTemplateContent());
                    template.setStatus(item.getAuditStatus());
                    template.setCreateTime(item.getCreateDate());
                    template.setName(item.getTemplateName());
                    template.setType(item.getTemplateType());
                    QuerySmsTemplateListResponseBody.QuerySmsTemplateListResponseBodySmsTemplateListReason reason = item.getReason();
                    if (null != reason) {
                        template.setRejectInfo(reason.getRejectInfo());
                        template.setRejectTime(reason.getRejectDate());
                        template.setRejectSubInfo(reason.getRejectSubInfo());
                    }
                    templates.add(template);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return templates;
        }

        public List<SMSTemplate> list(int page) {
            return this.list(page, 10);
        }

        public SMSTemplate info(String code) throws RuntimeException {
            SMSTemplate template = new SMSTemplate();
            template.setCode(code);
            template.setStatus(SMSTemplate.STATUS.ERROR);
            QuerySmsTemplateRequest req = new QuerySmsTemplateRequest().setTemplateCode(code);
            try {
                QuerySmsTemplateResponseBody body;
                QuerySmsTemplateResponse resp = SMSUtil.this.client.querySmsTemplate(req);
                if (null != resp && resp.getStatusCode() == 200 && "OK".equalsIgnoreCase((body = resp.getBody()).getCode())) {
                    template.setCode(code);
                    template.setType(body.getTemplateType());
                    template.setName(body.getTemplateName());
                    template.setContent(body.getTemplateContent());
                    template.setCreateTime(body.getCreateDate());
                    int status = body.getTemplateStatus();
                    if (status == 0) {
                        template.setStatus(SMSTemplate.STATUS.AUDIT_STATE_INIT);
                    } else if (status == 1) {
                        template.setStatus(SMSTemplate.STATUS.AUDIT_STATE_PASS);
                    } else if (status == 2) {
                        template.setStatus(SMSTemplate.STATUS.AUDIT_STATE_NOT_PASS);
                        template.setRejectInfo(body.getReason());
                    } else if (status == 10) {
                        template.setStatus(SMSTemplate.STATUS.AUDIT_SATE_CANCEL);
                    } else {
                        template.setStatus(SMSTemplate.STATUS.ERROR);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return template;
        }

        public boolean delete(String code) throws RuntimeException {
            DeleteSmsTemplateRequest req = new DeleteSmsTemplateRequest().setTemplateCode(code);
            try {
                DeleteSmsTemplateResponse resp = SMSUtil.this.client.deleteSmsTemplate(req);
                if (!"OK".equalsIgnoreCase(resp.getBody().getCode())) {
                    throw new Exception("\u5220\u9664\u5931\u8d25:" + resp.getBody().getMessage());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    public class Sign {
        public void request(String name, int source, String remark, List<String> files) {
        }
    }
}

