/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.aliyun.sms.util;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsRequest;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsResponse;
import com.aliyun.dysmsapi20170525.models.QuerySendDetailsResponseBody;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.aliyun.sms.util.SMSConfig;
import org.anyline.aliyun.sms.util.SMSResult;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSUtil {
    private static final Logger log = LoggerFactory.getLogger(SMSUtil.class);
    private SMSConfig config = null;
    private Client client;
    private static Hashtable<String, SMSUtil> instances = new Hashtable();
    static final String product = "Dysmsapi";
    static final String endpoint = "dysmsapi.aliyuncs.com";

    public static SMSUtil getInstance() {
        return SMSUtil.getInstance("default");
    }

    public static SMSUtil getInstance(String key) {
        SMSUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            SMSConfig config;
            util = new SMSUtil();
            util.config = config = SMSConfig.getInstance(key);
            try {
                Config cfg = new Config();
                cfg.setAccessKeyId(config.ACCESS_KEY);
                cfg.setAccessKeySecret(config.ACCESS_SECRET);
                cfg.endpoint = endpoint;
                util.client = new Client(cfg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            instances.put(key, util);
        }
        return util;
    }

    public SMSResult send(String sign, String template, String mobile, Map<String, String> params) {
        SMSResult result = new SMSResult();
        try {
            if (BasicUtil.isEmpty((Object)sign)) {
                sign = this.config.SMS_SIGN;
            }
            SendSmsRequest request = new SendSmsRequest().setSignName(sign).setTemplateCode(template).setPhoneNumbers(mobile).setTemplateParam(BeanUtil.map2json(params));
            RuntimeOptions runtime = new RuntimeOptions();
            SendSmsResponse response = this.client.sendSmsWithOptions(request, runtime);
            result.setStatus(response.getStatusCode());
            SendSmsResponseBody body = response.getBody();
            result.setCode(body.getCode());
            result.setMsg(body.getMessage());
            result.setBiz(body.getBizId());
            result.setResult(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setResult(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public SMSResult send(String sign, String template, String mobile, Object entity, List<String> keys) {
        return this.send(sign, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, String mobile, Object entity, String ... keys) {
        return this.send(sign, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Map<String, String> params) {
        String mobile = "";
        for (String item : mobiles) {
            if ("".equals(mobile)) {
                mobile = item;
                continue;
            }
            mobile = mobile + "," + item;
        }
        return this.send(sign, template, mobile, params);
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Object entity, List<String> keys) {
        return this.send(sign, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Object entity, String ... keys) {
        return this.send(sign, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String template, String mobile, Map<String, String> params) {
        return this.send(this.config.SMS_SIGN, template, mobile, params);
    }

    public SMSResult send(String template, String mobile, Object entity, List<String> keys) {
        return this.send(this.config.SMS_SIGN, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String template, String mobile, Object entity, String ... keys) {
        return this.send(this.config.SMS_SIGN, template, mobile, this.object2map(entity, keys));
    }

    public SMSResult send(String template, List<String> mobiles, Map<String, String> params) {
        return this.send(this.config.SMS_SIGN, template, mobiles, params);
    }

    public SMSResult send(String template, List<String> mobiles, Object entity, List<String> keys) {
        return this.send(this.config.SMS_SIGN, template, mobiles, this.object2map(entity, keys));
    }

    public SMSResult send(String template, List<String> mobiles, Object entity, String ... keys) {
        return this.send(this.config.SMS_SIGN, template, mobiles, this.object2map(entity, keys));
    }

    public List<SMSResult> status(String mobile, String biz, String date, int vol, int page) throws Exception {
        ArrayList<SMSResult> results = new ArrayList<SMSResult>();
        QuerySendDetailsRequest query = new QuerySendDetailsRequest().setPhoneNumber(mobile).setSendDate(date).setPageSize(Long.valueOf(vol)).setCurrentPage(Long.valueOf(page));
        if (BasicUtil.isNotEmpty((Object)biz)) {
            query.setBizId(biz);
        }
        QuerySendDetailsResponse queryResp = this.client.querySendDetails(query);
        List list = queryResp.getBody().getSmsSendDetailDTOs().getSmsSendDetailDTO();
        for (QuerySendDetailsResponseBody.QuerySendDetailsResponseBodySmsSendDetailDTOsSmsSendDetailDTO item : list) {
            SMSResult result = new SMSResult();
            result.setStatus(item.getSendStatus().intValue());
            result.setContent(item.getContent());
            result.setCode(item.getErrCode());
            result.setMobile(item.getPhoneNum());
            result.setOut(item.getOutId());
            result.setReceiveTime(item.getReceiveDate());
            result.setSendTime(item.getSendDate());
            result.setTemplate(item.getTemplateCode());
            results.add(result);
        }
        return results;
    }

    public SMSResult status(String mobile, String biz, String date) throws Exception {
        List<SMSResult> results = this.status(mobile, biz, date, 1, 1);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public SMSResult status(String mobile, String biz) throws Exception {
        return this.status(mobile, biz, DateUtil.format((String)"yyyyMMdd"));
    }

    public SMSResult status(String mobile) throws Exception {
        return this.status(mobile, null, DateUtil.format((String)"yyyyMMdd"));
    }

    public SMSConfig getConfig() {
        return this.config;
    }

    private Map<String, String> object2map(Object entity, List<String> keys) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (null != keys) {
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object value;
                String key;
                String field = key = iterator.next();
                if (key.contains(":")) {
                    String[] tmps = key.split(":");
                    key = tmps[0];
                    field = tmps[1];
                }
                if (null == (value = BeanUtil.getFieldValue((Object)entity, (String)field))) continue;
                params.put(key, value.toString());
            }
        }
        return params;
    }

    private Map<String, String> object2map(Object entity, String ... keys) {
        return this.object2map(entity, BeanUtil.array2list((Object[][])new String[][]{keys}));
    }
}

