/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.aliyun.sms.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.aliyun.sms.util.SMSConfig;
import org.anyline.aliyun.sms.util.SMSResult;
import org.anyline.net.HttpUtil;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSClient {
    private static final Logger log = LoggerFactory.getLogger(SMSClient.class);
    private SMSConfig config = null;
    private static Hashtable<String, SMSClient> instances = new Hashtable();

    public static SMSClient getInstance() {
        return SMSClient.getInstance("default");
    }

    public static SMSClient getInstance(String key) {
        SMSClient client;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (client = instances.get(key))) {
            SMSConfig config;
            client = new SMSClient();
            client.config = config = SMSConfig.getInstance(key);
            instances.put(key, client);
        }
        return client;
    }

    public SMSResult send(String sign, String template, String mobile, Map<String, String> params) {
        SMSResult result = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("_client_app", this.config.CLIENT_APP);
            map.put("_client_secret", this.config.CLIENT_SECRET);
            map.put("_sms_sign", sign);
            map.put("_sms_template", template);
            map.put("_sms_mobile", mobile);
            map.put("_sms_param", BeanUtil.map2json(params));
            String txt = HttpUtil.get((String)this.config.SMS_SERVER, (String)"UTF-8", map).getText();
            result = (SMSResult)BeanUtil.json2oject((String)txt, SMSResult.class);
            if (ConfigTable.isDebug() && log.isWarnEnabled()) {
                log.warn("[SMS SEND][mobile:{}][result:{}]", (Object)mobile, (Object)txt);
            }
        }
        catch (Exception e) {
            result = new SMSResult();
            result.setMsg(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public SMSResult send(String sign, String template, List<String> mobiles, Map<String, String> params) {
        String mobile = "";
        for (String item : mobiles) {
            if ("".equals(mobile)) {
                mobile = item;
                continue;
            }
            mobile = mobile + "," + item;
        }
        return this.send(sign, template, mobile, params);
    }

    public SMSResult send(String template, String mobile, Map<String, String> params) {
        return this.send(this.config.SMS_SIGN, template, mobile, params);
    }

    public SMSResult send(String template, List<String> mobile, Map<String, String> params) {
        return this.send(this.config.SMS_SIGN, template, mobile, params);
    }
}

