/*
 * Decompiled with CFR 0.152.
 */
package org.anyboot.jdbc.ds;

import org.anyline.jdbc.ds.DataSourceHolder;
import org.anyline.jdbc.ds.TargetDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=-1)
@Component
public class DynamicDattaSourceAspect {
    private Logger logger = LoggerFactory.getLogger(DynamicDattaSourceAspect.class);

    @Before(value="@annotation(targetDataSource)")
    public void changeDataSource(JoinPoint joinPoint, TargetDataSource targetDataSource) {
        String ds = targetDataSource.name();
        if (!DataSourceHolder.contains((String)ds)) {
            this.logger.error("[\u5207\u6362\u6570\u636e\u6e90][\u6570\u636e\u6e90\u4e0d\u5b58\u5728][\u6570\u636e\u6e90:{}][signature:{}]", (Object)ds, (Object)joinPoint.getSignature());
        } else {
            this.logger.warn("[\u5207\u6362\u6570\u636e\u6e90][\u6570\u636e\u6e90:{}]", (Object)ds);
            DataSourceHolder.setDataSource((String)ds);
        }
    }

    @After(value="@annotation(targetDataSource)")
    public void clearDataSource(JoinPoint joinPoint, TargetDataSource targetDataSource) {
        this.logger.warn("[\u6e05\u9664\u6570\u636e\u6e90][\u6570\u636e\u6e90:" + targetDataSource.name() + "]");
        DataSourceHolder.setDefaultDataSource();
    }
}

