/*
 * Decompiled with CFR 0.152.
 */
package org.anyboot.jdbc.ds;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.jdbc.ds.DataSourceHolder;
import org.anyline.jdbc.ds.DynamicDataSource;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DynamicDataSourceRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Logger log = LoggerFactory.getLogger(DynamicDataSourceRegister.class);
    private static final String DATASOURCE_TYPE_DEFAULT = "com.zaxxer.hikari.HikariDataSource";
    private DataSource defaultDataSource;
    private static Map<String, DataSource> springDataSources = new HashMap<String, DataSource>();

    public void setEnvironment(Environment environment) {
        this.initDefaultDataSource(environment);
        this.initSpringDataSources(environment);
    }

    private void initDefaultDataSource(Environment env) {
        this.defaultDataSource = DynamicDataSourceRegister.buildDataSource("spring.datasource", env);
    }

    private void initSpringDataSources(Environment env) {
        String prefixs = env.getProperty("spring.datasource.list");
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                DataSource ds = DynamicDataSourceRegister.buildDataSource("spring.datasource." + prefix, env);
                springDataSources.put(prefix, ds);
                this.log.warn("[\u521b\u5efa\u6570\u636e\u6e90][prefix:{}]", (Object)prefix);
            }
        }
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        targetDataSources.put("dataSource", this.defaultDataSource);
        DataSourceHolder.reg((String)"dataSource");
        targetDataSources.putAll(springDataSources);
        for (String key : springDataSources.keySet()) {
            this.log.warn("[\u6ce8\u518c\u6570\u636e\u6e90][key:{}]", (Object)key);
            DataSourceHolder.reg((String)key);
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(DynamicDataSource.class);
        beanDefinition.setSynthetic(true);
        MutablePropertyValues mpv = beanDefinition.getPropertyValues();
        mpv.addPropertyValue("defaultTargetDataSource", (Object)this.defaultDataSource);
        mpv.addPropertyValue("targetDataSources", targetDataSources);
        beanDefinitionRegistry.registerBeanDefinition("dataSource", (BeanDefinition)beanDefinition);
    }

    public static DataSource buildDataSource(String prefix, Environment env) {
        try {
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if ((type = DynamicDataSourceRegister.getProperty(prefix, env, "type")) == null) {
                type = DATASOURCE_TYPE_DEFAULT;
            }
            Class<?> dataSourceType = Class.forName(type);
            String driverClassName = DynamicDataSourceRegister.getProperty(prefix, env, "driver", "driver-class", "driver-class-name");
            String url = DynamicDataSourceRegister.getProperty(prefix, env, "url", "jdbc-url");
            String username = DynamicDataSourceRegister.getProperty(prefix, env, "user", "username");
            String password = DynamicDataSourceRegister.getProperty(prefix, env, "password");
            DataSourceBuilder factory = DataSourceBuilder.create().driverClassName(driverClassName).url(url).username(username).password(password).type(dataSourceType);
            DataSource ds = factory.build();
            DynamicDataSourceRegister.setFieldsValue(ds, "spring.datasource.", env);
            DynamicDataSourceRegister.setFieldsValue(ds, prefix, env);
            return ds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setFieldsValue(Object obj, String prefix, Environment env) {
        List fields = BeanUtil.getFieldsName(obj.getClass());
        for (String field : fields) {
            String value = DynamicDataSourceRegister.getProperty(prefix, env, field);
            if (!BasicUtil.isNotEmpty((Object)value)) continue;
            BeanUtil.setFieldValue((Object)obj, (String)field, (Object)value);
        }
    }

    private static String getProperty(String prefix, Environment env, String ... keys) {
        String value = null;
        if (null == env || null == keys) {
            return value;
        }
        if (null == prefix) {
            prefix = "";
        }
        for (String key : keys) {
            key = prefix + key;
            value = env.getProperty(key);
            if (null != value) {
                return value;
            }
            String[] ks = key.split("-");
            String sKey = null;
            for (String k : ks) {
                sKey = null == sKey ? k : sKey + CharUtil.toUpperCaseHeader((String)k);
            }
            value = env.getProperty(sKey);
            if (null != value) {
                return value;
            }
            ks = key.split("_");
            sKey = null;
            for (String k : ks) {
                sKey = null == sKey ? k : sKey + CharUtil.toUpperCaseHeader((String)k);
            }
            value = env.getProperty(sKey);
            if (null == value) continue;
            return value;
        }
        return value;
    }
}

