/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.model;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import org.anvilpowered.anvil.api.model.Mappable;
import org.anvilpowered.anvil.api.model.ObjectWithId;

public abstract class XodusDbo
implements ObjectWithId<EntityId>,
Mappable<Entity> {
    private EntityId id;
    private long createdUtcSeconds;
    private int createdUtcNanos;
    private long updatedUtcSeconds;
    private int updatedUtcNanos;

    protected XodusDbo() {
        Instant now = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        this.createdUtcSeconds = now.getEpochSecond();
        this.createdUtcNanos = now.getNano();
        this.prePersist();
    }

    @Override
    public EntityId getId() {
        return this.id;
    }

    @Override
    public void setId(EntityId id) {
        this.id = id;
    }

    @Override
    public String getIdAsString() {
        return this.id.toString();
    }

    @Override
    public Instant getCreatedUtc() {
        return Instant.ofEpochSecond(this.createdUtcSeconds, this.createdUtcNanos);
    }

    @Override
    public Instant getUpdatedUtc() {
        return Instant.ofEpochSecond(this.updatedUtcSeconds, this.updatedUtcNanos);
    }

    protected void prePersist() {
        Instant now = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        this.updatedUtcSeconds = now.getEpochSecond();
        this.updatedUtcNanos = now.getNano();
    }

    @Override
    public Entity writeTo(Entity object) {
        object.setProperty("createdUtcSeconds", (Comparable)Long.valueOf(this.createdUtcSeconds));
        object.setProperty("createdUtcNanos", (Comparable)Integer.valueOf(this.createdUtcNanos));
        object.setProperty("updatedUtcSeconds", (Comparable)Long.valueOf(this.updatedUtcSeconds));
        object.setProperty("updatedUtcNanos", (Comparable)Integer.valueOf(this.updatedUtcNanos));
        return object;
    }

    @Override
    public void readFrom(Entity object) {
        Comparable updatedUtcNanos;
        Comparable updatedUtcSeconds;
        Comparable createdUtcNanos;
        this.id = object.getId();
        Comparable createdUtcSeconds = object.getProperty("createdUtcSeconds");
        if (createdUtcSeconds instanceof Long) {
            this.createdUtcSeconds = (Long)createdUtcSeconds;
        }
        if ((createdUtcNanos = object.getProperty("createdUtcNanos")) instanceof Integer) {
            this.createdUtcNanos = (Integer)createdUtcNanos;
        }
        if ((updatedUtcSeconds = object.getProperty("updatedUtcSeconds")) instanceof Long) {
            this.updatedUtcSeconds = (Long)updatedUtcSeconds;
        }
        if ((updatedUtcNanos = object.getProperty("updatedUtcNanos")) instanceof Integer) {
            this.updatedUtcNanos = (Integer)updatedUtcNanos;
        }
    }
}

