/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.StoreTransaction;
import org.anvilpowered.anvil.api.datastore.CacheService;
import org.anvilpowered.anvil.api.datastore.CachedRepository;
import org.anvilpowered.anvil.api.datastore.StorageService;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.base.datastore.BaseXodusRepository;

public interface BaseXodusCachedRepository<T extends ObjectWithId<EntityId>, C extends CacheService<EntityId, T, PersistentEntityStore>>
extends BaseXodusRepository<T>,
CachedRepository<EntityId, T, C, PersistentEntityStore> {
    @Override
    default public CompletableFuture<Optional<T>> insertOne(T item) {
        return this.applyFromDBToCacheConditionally(() -> BaseXodusRepository.super.insertOne(item).join(), StorageService::insertOne);
    }

    @Override
    default public CompletableFuture<List<T>> insert(List<T> list) {
        return this.applyFromDBToCache(() -> BaseXodusRepository.super.insert(list).join(), StorageService::insert);
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(EntityId id) {
        return this.applyToBothConditionally(c -> c.getOne(id).join(), () -> BaseXodusRepository.super.getOne(id).join());
    }

    @Override
    default public CompletableFuture<Boolean> delete(Function<? super StoreTransaction, ? extends Iterable<Entity>> query) {
        return this.applyFromDBToCache(() -> (List)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            ArrayList toDelete = new ArrayList();
            ((Iterable)query.apply(txn)).forEach(entity -> {
                toDelete.add(entity.getId());
                entity.delete();
            });
            return txn.commit() ? toDelete : Collections.emptyList();
        }), (c, toDelete) -> toDelete.forEach(id -> c.deleteOne(id).join())).thenApplyAsync(result -> !result.isEmpty());
    }

    @Override
    default public CompletableFuture<Boolean> deleteOne(EntityId id) {
        return this.applyFromDBToCache(() -> BaseXodusRepository.super.deleteOne(id).join(), (c, b) -> {
            if (b.booleanValue()) {
                c.deleteOne(id).join();
            }
        });
    }
}

