/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.datastore.MongoRepository;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.api.util.TimeFormatService;
import org.anvilpowered.anvil.base.datastore.BaseMongoComponent;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public interface BaseMongoRepository<T extends ObjectWithId<ObjectId>>
extends MongoRepository<T>,
BaseMongoComponent {
    @Override
    default public CompletableFuture<Optional<Instant>> getCreatedUtc(ObjectId id) {
        return CompletableFuture.completedFuture(Optional.of(Instant.ofEpochSecond(id.getTimestamp())));
    }

    @Override
    default public CompletableFuture<Optional<T>> insertOne(T item) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ((Datastore)this.getDataStoreContext().getDataStore()).save((Object)item);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return Optional.empty();
            }
            return Optional.of(item);
        });
    }

    @Override
    default public CompletableFuture<List<T>> insert(List<T> list) {
        return CompletableFuture.supplyAsync(() -> list.stream().filter(item -> {
            try {
                ((Datastore)this.getDataStoreContext().getDataStore()).save(item);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }).collect(Collectors.toList()));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(Query<T> query) {
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(query.get()));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(ObjectId id) {
        return this.getOne(this.asQuery(id));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(Instant createdUtc) {
        return this.getOne(this.asQuery(createdUtc));
    }

    @Override
    default public CompletableFuture<List<ObjectId>> getAllIds() {
        return CompletableFuture.supplyAsync(() -> this.asQuery().project("_id", true).asList().stream().map(ObjectWithId::getId).collect(Collectors.toList()));
    }

    @Override
    default public CompletableFuture<Boolean> delete(Query<T> query) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return ((Datastore)this.getDataStoreContext().getDataStore()).delete(query).getN() > 0;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    @Override
    default public CompletableFuture<Boolean> deleteOne(ObjectId id) {
        return this.delete(this.asQuery(id));
    }

    @Override
    default public CompletableFuture<Boolean> deleteOne(Instant createdUtc) {
        return this.delete(this.asQuery(createdUtc));
    }

    @Override
    default public UpdateOperations<T> createUpdateOperations() {
        return ((Datastore)this.getDataStoreContext().getDataStore()).createUpdateOperations(this.getTClass());
    }

    @Override
    default public UpdateOperations<T> inc(String field, Number value) {
        return this.createUpdateOperations().inc(field, value);
    }

    @Override
    default public UpdateOperations<T> inc(String field) {
        return this.inc(field, 1);
    }

    @Override
    default public UpdateOperations<T> set(String field, Object value) {
        return this.createUpdateOperations().set(field, value);
    }

    @Override
    default public UpdateOperations<T> unSet(String field) {
        return this.createUpdateOperations().unset(field);
    }

    @Override
    default public CompletableFuture<Boolean> update(Query<T> query, UpdateOperations<T> updateOperations) {
        return CompletableFuture.supplyAsync(() -> ((Datastore)this.getDataStoreContext().getDataStore()).update(query, updateOperations).getUpdatedCount() > 0);
    }

    @Override
    default public CompletableFuture<Boolean> update(Optional<Query<T>> optionalQuery, UpdateOperations<T> updateOperations) {
        return optionalQuery.map(q -> this.update((Query<T>)q, updateOperations)).orElse(CompletableFuture.completedFuture(false));
    }

    @Override
    default public CompletableFuture<List<T>> getAll() {
        return this.getAll(this.asQuery());
    }

    @Override
    default public CompletableFuture<List<T>> getAll(Query<T> query) {
        return CompletableFuture.supplyAsync(() -> query.asList());
    }

    @Override
    default public Query<T> asQuery() {
        return ((Datastore)this.getDataStoreContext().getDataStore()).createQuery(this.getTClass());
    }

    @Override
    default public Query<T> asQuery(ObjectId id) {
        return (Query)this.asQuery().field("_id").equal((Object)id);
    }

    @Override
    default public Query<T> asQuery(Instant createdUtc) {
        String time = Integer.toHexString((int)createdUtc.getEpochSecond());
        return (Query)((Query)this.asQuery().field("_id").greaterThan((Object)new ObjectId(time + "0000000000000000"))).field("_id").lessThan((Object)new ObjectId(time + "ffffffffffffffff"));
    }

    @Override
    default public Optional<Query<T>> asQueryForIdOrTime(String idOrTime) {
        return this.parse(idOrTime).map(id -> Optional.of(this.asQuery((ObjectId)id))).orElseGet(() -> ((TimeFormatService)Anvil.getEnvironmentManager().getCoreEnvironment().getInjector().getInstance(TimeFormatService.class)).parseInstant(idOrTime).map(this::asQuery));
    }
}

