/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.anvilpowered.anvil.api.datastore.CacheService;
import org.anvilpowered.anvil.api.datastore.CachedRepository;
import org.anvilpowered.anvil.api.datastore.StorageService;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.base.datastore.BaseMongoRepository;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;

public interface BaseMongoCachedRepository<T extends ObjectWithId<ObjectId>, C extends CacheService<ObjectId, T, Datastore>>
extends BaseMongoRepository<T>,
CachedRepository<ObjectId, T, C, Datastore> {
    @Override
    default public CompletableFuture<Optional<T>> insertOne(T item) {
        return this.applyFromDBToCacheConditionally(() -> BaseMongoRepository.super.insertOne(item).join(), StorageService::insertOne);
    }

    @Override
    default public CompletableFuture<List<T>> insert(List<T> list) {
        return this.applyFromDBToCache(() -> BaseMongoRepository.super.insert(list).join(), StorageService::insert);
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(ObjectId id) {
        return this.applyToBothConditionally(c -> c.getOne(id).join(), () -> BaseMongoRepository.super.getOne(id).join());
    }
}

