/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.util.Locale;
import java.util.Map;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.data.registry.RegistryScoped;
import org.anvilpowered.anvil.api.datastore.Component;
import org.anvilpowered.anvil.api.datastore.Manager;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BaseManager<C extends Component<?, ?>>
implements Manager<C> {
    protected Registry registry;
    private final TypeToken<C> componentType;
    @Inject
    private Injector injector;
    @RegistryScoped
    private @Nullable C currentComponent;

    protected BaseManager(Registry registry) {
        this.registry = registry;
        registry.whenLoaded(this::registryLoaded).register();
        this.componentType = new TypeToken<C>(this.getClass()){};
    }

    private void registryLoaded() {
        this.currentComponent = null;
    }

    private void loadComponent() {
        String dataStoreName = this.registry.getExtraSafe(Keys.DATA_STORE_NAME).toLowerCase(Locale.ENGLISH);
        String type = this.componentType.getRawType().getCanonicalName();
        Named named = Names.named((String)dataStoreName);
        for (Map.Entry entry : this.injector.getBindings().entrySet()) {
            Key k = (Key)entry.getKey();
            if (!k.getTypeLiteral().getType().getTypeName().contains(type) || !named.equals(k.getAnnotation())) continue;
            this.currentComponent = (Component)((Binding)entry.getValue()).getProvider().get();
            return;
        }
        String message = "Anvil: Could not find requested data store: \"" + dataStoreName + "\". Did you bind it correctly?";
        System.err.println(message);
        throw new IllegalStateException(message);
    }

    @Override
    @RegistryScoped
    public C getPrimaryComponent() {
        try {
            if (this.currentComponent == null) {
                this.loadComponent();
            }
            return (C)((Component)Preconditions.checkNotNull(this.currentComponent, (Object)"An error occurred while loading current component"));
        }
        catch (RuntimeException e) {
            String message = "Anvil: DataStoreName has not been loaded yet!Make sure your Registry and ConfigurationService implementationsare annotated with @Singleton!";
            System.err.println(message);
            throw new IllegalStateException(message, e);
        }
    }
}

