/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.data.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.data.key.Key;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.data.registry.RegistryScope;
import org.anvilpowered.anvil.api.data.registry.RegistryScoped;

@Singleton
public class BaseRegistry
implements Registry {
    private final Map<Key<?>, Object> defaultMap = new HashMap();
    private final Map<Key<?>, Object> valueMap = new HashMap();
    private final Table<RegistryScope, Integer, Collection<Runnable>> listeners = HashBasedTable.create((int)2, (int)3);
    private Registry coreRegistry;
    private String stringRepresentation;

    @Override
    public <T> T getUnsafe(Key<T> key) {
        Object t;
        try {
            t = this.valueMap.get(key);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException("Value for key " + key + " is of the wrong type!");
        }
        if (t == null) {
            throw new NoSuchElementException("Could not find value for key " + key);
        }
        return (T)t;
    }

    @Override
    public <T> Optional<T> get(Key<T> key) {
        try {
            return Optional.ofNullable(this.valueMap.get(key));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public <T> T getDefault(Key<T> key) {
        Object result = null;
        try {
            result = this.defaultMap.get(key);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return (T)(result == null ? key.getFallbackValue() : result);
    }

    @Override
    public <T> void set(Key<T> key, T value) {
        this.valueMap.put(key, value);
        this.stringRepresentation = null;
    }

    @RegistryScoped
    protected <T> void setDefault(Key<T> key, T value) {
        this.defaultMap.put(key, value);
        this.stringRepresentation = null;
    }

    @Override
    public <T> T getExtraSafe(Key<T> key) {
        if (this.coreRegistry == null) {
            this.coreRegistry = Anvil.getServiceManager().provide(Registry.class);
        }
        if (this != this.coreRegistry && this.getOrDefault(Keys.USE_SHARED_ENVIRONMENT).booleanValue()) {
            if (key.equals(Keys.DATA_STORE_NAME) || key.equals(Keys.MONGODB_HOSTNAME) || key.equals(Keys.MONGODB_PORT) || key.equals(Keys.MONGODB_USE_SRV)) {
                return this.coreRegistry.getOrDefault(key);
            }
            if (this.getOrDefault(Keys.USE_SHARED_CREDENTIALS).booleanValue() && (key.equals(Keys.MONGODB_USE_CONNECTION_STRING) || key.equals(Keys.MONGODB_CONNECTION_STRING) || key.equals(Keys.MONGODB_USERNAME) || key.equals(Keys.MONGODB_PASSWORD) || key.equals(Keys.MONGODB_AUTH_DB) || key.equals(Keys.MONGODB_USE_AUTH))) {
                return this.coreRegistry.getOrDefault(key);
            }
        }
        return this.getOrDefault(key);
    }

    @Override
    public <T> void remove(Key<T> key) {
        this.valueMap.remove(key);
        this.stringRepresentation = null;
    }

    @Override
    public <T> void transform(Key<T> key, BiFunction<? super Key<T>, ? super T, ? extends T> transformer) {
        this.valueMap.compute(key, transformer);
        this.stringRepresentation = null;
    }

    @Override
    public <T> void transform(Key<T> key, Function<? super T, ? extends T> transformer) {
        this.transform(key, (? super Key<T> k, ? super T v) -> transformer.apply(v));
        this.stringRepresentation = null;
    }

    @Override
    public <T> void addToCollection(Key<? extends Collection<T>> key, T value) {
        ((Collection)this.valueMap.get(key)).add(value);
        this.stringRepresentation = null;
    }

    @Override
    public <T> void removeFromCollection(Key<? extends Collection<T>> key, T value) {
        ((Collection)this.valueMap.get(key)).remove(value);
        this.stringRepresentation = null;
    }

    @Override
    public <K, T> void putInMap(Key<? extends Map<K, T>> key, K mapKey, T mapValue) {
        ((Map)this.valueMap.get(key)).put(mapKey, mapValue);
        this.stringRepresentation = null;
    }

    @Override
    public <K, T> void removeFromMap(Key<? extends Map<K, T>> key, K mapKey) {
        ((Map)this.valueMap.get(key)).remove(mapKey);
        this.stringRepresentation = null;
    }

    @Override
    public Registry.ListenerRegistrationEnd whenLoaded(Runnable listener) {
        return new ListenerRegistrationEndImpl(listener);
    }

    @Override
    public void load(RegistryScope registryScope) {
        int ordinal = registryScope.ordinal();
        if (ordinal <= RegistryScope.DEFAULT.ordinal()) {
            this.loadDefaultScope();
        }
        this.loadOrdinal(ordinal);
    }

    protected final void loadOrdinal(int ordinal) {
        RegistryScope[] values = RegistryScope.values();
        int valueLength = values.length;
        for (int i = ordinal; i < valueLength; ++i) {
            this.listeners.row((Object)values[i]).forEach((n, l) -> l.forEach(Runnable::run));
        }
    }

    @RegistryScoped
    protected void loadDefaultScope() {
    }

    public String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        HashSet keys = new HashSet();
        int[] width = new int[]{0, 32, 32};
        Consumer<Key> addToKeys = key -> {
            int keyLength = key.toString().length();
            if (keyLength > width[0]) {
                width[0] = keyLength;
            }
            keys.add(key);
        };
        this.valueMap.keySet().forEach(addToKeys);
        this.defaultMap.keySet().forEach(addToKeys);
        width[0] = width[0] + 5;
        this.stringRepresentation = String.format("%-" + width[0] + "s", "Key") + String.format("%-" + width[1] + "s", "Value") + String.format("%-" + width[2] + "s", "Default") + '\n' + keys.stream().map(key -> String.format("%-" + width[0] + "s", key.toString()) + String.format("%-" + width[1] + "s", this.valueMap.get(key)) + String.format("%-" + width[2] + "s", this.defaultMap.get(key))).collect(Collectors.joining("\n"));
        return this.stringRepresentation;
    }

    private class ListenerRegistrationEndImpl
    implements Registry.ListenerRegistrationEnd {
        private final Runnable listener;
        private int order;
        private RegistryScope registryScope;

        public ListenerRegistrationEndImpl(Runnable listener) {
            this.listener = listener;
            this.order = 0;
            this.registryScope = RegistryScope.DEFAULT;
        }

        @Override
        public Registry.ListenerRegistrationEnd order(int order) {
            this.order = 0;
            return this;
        }

        @Override
        public Registry.ListenerRegistrationEnd scope(RegistryScope registryScope) {
            this.registryScope = registryScope;
            return this;
        }

        @Override
        public void register() {
            BaseRegistry.this.listeners.row((Object)this.registryScope).computeIfAbsent(this.order, o -> new ArrayList()).add(this.listener);
        }
    }
}

