/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.datastore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Paths;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.DataStoreContext;
import org.anvilpowered.anvil.api.datastore.XodusEmbedded;
import org.anvilpowered.anvil.api.datastore.XodusEntity;
import org.anvilpowered.anvil.api.model.Mappable;

@Singleton
public final class XodusContext
extends DataStoreContext<EntityId, PersistentEntityStore> {
    @Inject
    public XodusContext(Registry registry) {
        super(registry);
    }

    @Override
    protected void closeConnection(PersistentEntityStore dataStore) {
        dataStore.close();
    }

    @Override
    protected PersistentEntityStore loadDataStore() {
        Class<?>[] entityClasses;
        File dbFilesLocation = Paths.get(this.registry.getOrDefault(Keys.DATA_DIRECTORY) + "/data/xodus", new String[0]).toFile();
        if (!dbFilesLocation.exists() && !dbFilesLocation.mkdirs()) {
            throw new IllegalStateException("Unable to create xodus directory");
        }
        for (Class<?> entityClass : entityClasses = this.calculateEntityClasses(this.registry.getOrDefault(Keys.BASE_SCAN_PACKAGE), XodusEntity.class, XodusEmbedded.class)) {
            if (Mappable.class.isAssignableFrom(entityClass)) {
                try {
                    entityClass.getDeclaredMethod("writeTo", Entity.class);
                    entityClass.getDeclaredMethod("readFrom", Entity.class);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Xodus entity class " + entityClass.getName() + " must implement Mappable#writeTo(T) and Mappable#readFrom(T)", e);
                }
            }
            if (!entityClass.isAnnotationPresent(XodusEntity.class)) continue;
            throw new IllegalStateException("Xodus entity class " + entityClass.getName() + " must extend org.anvilpowered.anvil.model.data.dbo.Mappable");
        }
        this.setTKeyClass(EntityId.class);
        return PersistentEntityStores.newInstance((String)dbFilesLocation.getPath());
    }
}

