/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.datastore;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.anvilpowered.anvil.api.datastore.Component;
import org.anvilpowered.anvil.api.model.ObjectWithId;

public interface StorageService<TKey, T extends ObjectWithId<TKey>, TDataStore>
extends Component<TKey, TDataStore> {
    public T generateEmpty();

    public Class<T> getTClass();

    public CompletableFuture<Optional<T>> insertOne(T var1);

    public CompletableFuture<List<T>> insert(List<T> var1);

    public CompletableFuture<List<TKey>> getAllIds();

    public CompletableFuture<List<T>> getAll();

    public CompletableFuture<Optional<T>> getOne(TKey var1);

    public CompletableFuture<Optional<T>> getOne(Instant var1);

    public CompletableFuture<Optional<T>> parseAndGetOne(Object var1);

    public CompletableFuture<Boolean> deleteOne(TKey var1);

    public CompletableFuture<Boolean> deleteOne(Instant var1);

    public CompletableFuture<Boolean> parseAndDeleteOne(Object var1);
}

