/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.datastore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.DataStoreContext;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.mapping.DefaultCreator;

@Singleton
public final class MongoContext
extends DataStoreContext<ObjectId, Datastore> {
    @Inject
    public MongoContext(Registry registry) {
        super(registry);
    }

    @Override
    protected void closeConnection(Datastore dataStore) {
        dataStore.getMongo().close();
    }

    @Override
    protected Datastore loadDataStore() {
        String clientUrl;
        String pt;
        String connectionString = this.registry.getExtraSafe(Keys.MONGODB_CONNECTION_STRING);
        String hostname = this.registry.getExtraSafe(Keys.MONGODB_HOSTNAME);
        int port = this.registry.getExtraSafe(Keys.MONGODB_PORT);
        String dbName = this.registry.getExtraSafe(Keys.MONGODB_DBNAME);
        String username = this.registry.getExtraSafe(Keys.MONGODB_USERNAME);
        String password = this.registry.getExtraSafe(Keys.MONGODB_PASSWORD);
        String authDb = this.registry.getExtraSafe(Keys.MONGODB_AUTH_DB);
        boolean useAuth = this.registry.getExtraSafe(Keys.MONGODB_USE_AUTH);
        boolean useSrv = this.registry.getExtraSafe(Keys.MONGODB_USE_SRV);
        boolean useConnectionString = this.registry.getExtraSafe(Keys.MONGODB_USE_CONNECTION_STRING);
        String protocol = useSrv ? "mongodb+srv://" : "mongodb://";
        String string = pt = useSrv ? "" : ":" + port;
        if (useConnectionString) {
            clientUrl = connectionString;
        } else if (useAuth) {
            String encodedPassword = password;
            try {
                encodedPassword = URLEncoder.encode(password, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            clientUrl = protocol + username + ":" + encodedPassword + "@" + hostname + pt + "/" + dbName + "?authSource=" + authDb;
        } else {
            clientUrl = protocol + hostname + pt + "/" + dbName;
        }
        MongoClientURI uri = new MongoClientURI(clientUrl);
        MongoClient mongoClient = new MongoClient(uri);
        Morphia morphia = new Morphia();
        Datastore dataStore = morphia.createDatastore(mongoClient, dbName);
        dataStore.ensureIndexes();
        morphia.map((Class[])this.calculateEntityClasses(this.registry.getOrDefault(Keys.BASE_SCAN_PACKAGE), Entity.class, Embedded.class));
        morphia.getMapper().getOptions().setObjectFactory((ObjectFactory)new DefaultCreator(){

            protected ClassLoader getClassLoaderForClass() {
                return MongoContext.this.getClass().getClassLoader();
            }
        });
        this.setTKeyClass(ObjectId.class);
        return dataStore;
    }
}

