/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.data.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.anvilpowered.anvil.api.data.key.Key;
import org.anvilpowered.anvil.api.data.registry.RegistryScope;
import org.anvilpowered.anvil.api.data.registry.RegistryScoped;

public interface Registry {
    @RegistryScoped
    public <T> T getUnsafe(Key<T> var1);

    @RegistryScoped
    public <T> Optional<T> get(Key<T> var1);

    @RegistryScoped
    default public <T> T getDefault(Key<T> key) {
        return key.getFallbackValue();
    }

    @RegistryScoped
    default public <T> T getOrDefault(Key<T> key) {
        return this.get(key).orElse(this.getDefault(key));
    }

    @RegistryScoped
    default public <T> T getExtraSafe(Key<T> key) {
        return this.getOrDefault(key);
    }

    @RegistryScoped
    public <T> void set(Key<T> var1, T var2);

    @RegistryScoped
    public <T> void remove(Key<T> var1);

    @RegistryScoped
    public <T> void transform(Key<T> var1, BiFunction<? super Key<T>, ? super T, ? extends T> var2);

    @RegistryScoped
    public <T> void transform(Key<T> var1, Function<? super T, ? extends T> var2);

    @RegistryScoped
    public <T> void addToCollection(Key<? extends Collection<T>> var1, T var2);

    @RegistryScoped
    public <T> void removeFromCollection(Key<? extends Collection<T>> var1, T var2);

    @RegistryScoped
    public <K, T> void putInMap(Key<? extends Map<K, T>> var1, K var2, T var3);

    @RegistryScoped
    public <K, T> void removeFromMap(Key<? extends Map<K, T>> var1, K var2);

    @RegistryScoped
    public void load(RegistryScope var1);

    @RegistryScoped
    default public void load() {
        this.load(RegistryScope.DEFAULT);
    }

    public ListenerRegistrationEnd whenLoaded(Runnable var1);

    public static interface ListenerRegistrationEnd {
        public ListenerRegistrationEnd order(int var1);

        public ListenerRegistrationEnd scope(RegistryScope var1);

        public void register();
    }
}

