/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.data.key;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Iterator;
import java.util.Optional;
import org.anvilpowered.anvil.api.data.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Keys {
    private static final String GLOBAL_NAMESPACE = "global";
    private static final Table<String, String, Key<?>> keys = HashBasedTable.create();
    public static final Key<String> SERVER_NAME = new Key<String>("SERVER_NAME", "server"){};
    public static final Key<Boolean> PROXY_MODE = new Key<Boolean>("PROXY_MODE", Boolean.valueOf(false)){};
    public static final Key<String> BASE_SCAN_PACKAGE = new Key<String>("BASE_SCAN_PACKAGE", "org.anvilpowered.anvil.common.model"){};
    public static final Key<Integer> CACHE_INVALIDATION_INTERVAL_SECONDS = new Key<Integer>("CACHE_INVALIDATION_INTERVAL_SECONDS", Integer.valueOf(30)){};
    public static final Key<Integer> CACHE_INVALIDATION_TIMOUT_SECONDS = new Key<Integer>("CACHE_INVALIDATION_TIMOUT_SECONDS", Integer.valueOf(300)){};
    public static final Key<Boolean> USE_SHARED_ENVIRONMENT = new Key<Boolean>("USE_SHARED_ENVIRONMENT", Boolean.valueOf(false)){};
    public static final Key<Boolean> USE_SHARED_CREDENTIALS = new Key<Boolean>("USE_SHARED_CREDENTIALS", Boolean.valueOf(false)){};
    public static final Key<String> DATA_DIRECTORY = new Key<String>("DATA_DIRECTORY", "anvil"){};
    public static final Key<String> DATA_STORE_NAME = new Key<String>("DATA_STORE_NAME", "xodus"){};
    public static final Key<String> MONGODB_CONNECTION_STRING = new Key<String>("MONGODB_CONNECTION_STRING", "mongodb://admin:password@localhost:27017/anvil?authSource=admin"){};
    public static final Key<String> MONGODB_HOSTNAME = new Key<String>("MONGODB_HOSTNAME", "localhost"){};
    public static final Key<Integer> MONGODB_PORT = new Key<Integer>("MONGODB_PORT", Integer.valueOf(27017)){};
    public static final Key<String> MONGODB_DBNAME = new Key<String>("MONGODB_DBNAME", "anvil"){};
    public static final Key<String> MONGODB_USERNAME = new Key<String>("MONGODB_USERNAME", "admin"){};
    public static final Key<String> MONGODB_PASSWORD = new Key<String>("MONGODB_PASSWORD", "password"){};
    public static final Key<String> MONGODB_AUTH_DB = new Key<String>("MONGODB_AUTH_DB", "admin"){};
    public static final Key<Boolean> MONGODB_USE_AUTH = new Key<Boolean>("MONGODB_USE_AUTH", Boolean.valueOf(false)){};
    public static final Key<Boolean> MONGODB_USE_SRV = new Key<Boolean>("MONGODB_USE_SRV", Boolean.valueOf(false)){};
    public static final Key<Boolean> MONGODB_USE_CONNECTION_STRING = new Key<Boolean>("MONGODB_USE_CONNECTION_STRING", Boolean.valueOf(false)){};
    public static final Key<String> REDIS_HOSTNAME = new Key<String>("REDIS_HOSTNAME", "localhost"){};
    public static final Key<Integer> REDIS_PORT = new Key<Integer>("REDIS_PORT", Integer.valueOf(6379)){};
    public static final Key<String> REDIS_PASSWORD = new Key<String>("REDIS_PASSWORD", "username"){};
    public static final Key<Boolean> REDIS_USE_AUTH = new Key<Boolean>("REDIS_USE_AUTH", Boolean.valueOf(false)){};

    private Keys() {
        throw new AssertionError((Object)"**boss music** No instance for you!");
    }

    public static KeyRegistrationEnd startRegistration(String nameSpace) {
        return new KeyRegistrationEnd(nameSpace);
    }

    public static <T> Key<T> resolveUnsafe(String name, String nameSpace) {
        return (Key)Preconditions.checkNotNull((Object)keys.get((Object)nameSpace, (Object)name));
    }

    public static <T> Key<T> resolveUnsafe(String name) {
        return Keys.resolve(name).orElseThrow(() -> new IllegalArgumentException("Could not resolve key " + name));
    }

    public static <T> Optional<Key<T>> resolve(String name) {
        @Nullable Key candidate = (Key)keys.get((Object)GLOBAL_NAMESPACE, (Object)name);
        if (candidate != null) {
            return Optional.of(candidate);
        }
        Iterator it = keys.column((Object)name).values().iterator();
        if (it.hasNext()) {
            return Optional.of((Key)it.next());
        }
        return Optional.empty();
    }

    static {
        Keys.startRegistration(GLOBAL_NAMESPACE).register(SERVER_NAME).register(PROXY_MODE).register(BASE_SCAN_PACKAGE).register(CACHE_INVALIDATION_INTERVAL_SECONDS).register(CACHE_INVALIDATION_TIMOUT_SECONDS).register(USE_SHARED_ENVIRONMENT).register(USE_SHARED_CREDENTIALS).register(DATA_DIRECTORY).register(DATA_STORE_NAME).register(MONGODB_HOSTNAME).register(MONGODB_PORT).register(MONGODB_DBNAME).register(MONGODB_USERNAME).register(MONGODB_PASSWORD).register(MONGODB_AUTH_DB).register(MONGODB_USE_AUTH).register(MONGODB_USE_SRV).register(REDIS_HOSTNAME).register(REDIS_PORT).register(REDIS_PASSWORD).register(REDIS_USE_AUTH);
    }

    public static final class KeyRegistrationEnd {
        private final String nameSpace;

        KeyRegistrationEnd(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        private void checkName(String nameSpace, String name) {
            if (keys.contains((Object)nameSpace, (Object)name)) {
                throw new IllegalArgumentException("The provided key " + name + " conflicts with a key of the same name in the " + nameSpace + " namespace.");
            }
        }

        public KeyRegistrationEnd register(Key<?> key) {
            String name = key.getName();
            this.checkName(this.nameSpace, name);
            keys.put((Object)this.nameSpace, (Object)key.getName(), key);
            return this;
        }
    }
}

