/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.core.coremember.repository;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.anvilpowered.anvil.api.core.model.coremember.CoreMember;
import org.anvilpowered.anvil.api.datastore.Repository;

public interface CoreMemberRepository<TKey, TDataStore>
extends Repository<TKey, CoreMember<TKey>, TDataStore> {
    public CompletableFuture<Optional<CoreMember<TKey>>> getOneOrGenerateForUser(UUID var1, String var2, String var3, boolean[] var4);

    public CompletableFuture<Optional<CoreMember<TKey>>> getOneOrGenerateForUser(UUID var1, String var2, String var3);

    public CompletableFuture<Optional<CoreMember<TKey>>> getOneForUser(UUID var1);

    public CompletableFuture<Optional<CoreMember<TKey>>> getOneForUser(String var1);

    public CompletableFuture<List<CoreMember<TKey>>> getForIpAddress(String var1);

    public CompletableFuture<Boolean> ban(TKey var1, Instant var2, String var3);

    public CompletableFuture<Boolean> banUser(UUID var1, Instant var2, String var3);

    public CompletableFuture<Boolean> banUser(String var1, Instant var2, String var3);

    public CompletableFuture<Boolean> banIpAddress(String var1, Instant var2, String var3);

    public CompletableFuture<Boolean> unBan(TKey var1);

    public CompletableFuture<Boolean> unBanUser(UUID var1);

    public CompletableFuture<Boolean> unBanUser(String var1);

    public CompletableFuture<Boolean> unBanIpAddress(String var1);

    public boolean checkBanned(CoreMember<?> var1);

    public CompletableFuture<Boolean> checkBanned(TKey var1);

    public CompletableFuture<Boolean> checkBannedForUser(UUID var1);

    public CompletableFuture<Boolean> checkBannedForUser(String var1);

    public CompletableFuture<Boolean> mute(TKey var1, Instant var2, String var3);

    public CompletableFuture<Boolean> muteUser(UUID var1, Instant var2, String var3);

    public CompletableFuture<Boolean> muteUser(String var1, Instant var2, String var3);

    public CompletableFuture<Boolean> muteIpAddress(String var1, Instant var2, String var3);

    public CompletableFuture<Boolean> unMute(TKey var1);

    public CompletableFuture<Boolean> unMuteUser(UUID var1);

    public CompletableFuture<Boolean> unMuteUser(String var1);

    public CompletableFuture<Boolean> unMuteIpAddress(String var1);

    public boolean checkMuted(CoreMember<?> var1);

    public CompletableFuture<Boolean> checkMuted(TKey var1);

    public CompletableFuture<Boolean> checkMutedForUser(UUID var1);

    public CompletableFuture<Boolean> checkMutedForUser(String var1);

    public CompletableFuture<Boolean> setNickName(TKey var1, String var2);

    public CompletableFuture<Boolean> setNickNameForUser(UUID var1, String var2);

    public CompletableFuture<Boolean> setNickNameForUser(String var1, String var2);

    public CompletableFuture<Boolean> deleteNickName(TKey var1);

    public CompletableFuture<Boolean> deleteNickNameForUser(UUID var1);

    public CompletableFuture<Boolean> deleteNickNameForUser(String var1);
}

