/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.function.Consumer;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.misc.Named;
import org.anvilpowered.anvil.api.plugin.PluginInfo;
import org.anvilpowered.anvil.api.util.TextService;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Environment
extends Named,
Comparable<Environment> {
    public static <T> Binding<T> getBinding(String name, Injector injector) {
        long hash = (long)name.hashCode() * (long)injector.hashCode();
        Binding[] binding = new Binding[]{Anvil.bindingsCache.get(hash)};
        if (binding[0] != null) {
            return binding[0];
        }
        injector.getBindings().forEach((k, v) -> {
            if (k.getTypeLiteral().getType().getTypeName().contains(name)) {
                binding[0] = v;
            }
        });
        Binding result = (Binding)Preconditions.checkNotNull((Object)binding[0], (Object)("Could not find binding for service: " + name + " in injector " + injector));
        Anvil.bindingsCache.put(hash, result);
        return result;
    }

    public static <T> Key<T> getKey(String name, Injector injector) {
        return Environment.getBinding(name, injector).getKey();
    }

    public static <T> Provider<T> getProvider(String name, Injector injector) {
        return Environment.getBinding(name, injector).getProvider();
    }

    public static <T> T getInstance(String name, Injector injector) {
        return (T)Environment.getProvider(name, injector).get();
    }

    default public <T> Binding<T> getBinding(String name) {
        return Environment.getBinding(name, this.getInjector());
    }

    default public <T> Key<T> getKey(String name) {
        return Environment.getKey(name, this.getInjector());
    }

    default public <T> Provider<T> getProvider(String name) {
        return Environment.getProvider(name, this.getInjector());
    }

    default public <T> T getInstance(String name) {
        return Environment.getInstance(name, this.getInjector());
    }

    public void reload();

    public Injector getInjector();

    public Object getPlugin();

    public <TString> PluginInfo<TString> getPluginInfo();

    public <TString, TCommandSource> TextService<TString, TCommandSource> getTextService();

    public Registry getRegistry();

    public static interface Builder {
        public Builder addModules(Module ... var1);

        public Builder addModules(Iterable<Module> var1);

        public Builder addEarlyServices(Key<?> ... var1);

        public Builder addEarlyServices(Iterable<Key<?>> var1);

        public Builder addEarlyServices(Class<?> ... var1);

        public Builder addEarlyServices(TypeLiteral<?> ... var1);

        public Builder addEarlyServices(TypeToken<?> ... var1);

        public <T> Builder addEarlyServices(Key<T> var1, Consumer<T> var2);

        public <T> Builder addEarlyServices(Class<T> var1, Consumer<T> var2);

        public <T> Builder addEarlyServices(TypeLiteral<T> var1, Consumer<T> var2);

        public <T> Builder addEarlyServices(TypeToken<T> var1, Consumer<T> var2);

        public Builder setName(String var1);

        public Builder setRootInjector(@Nullable Injector var1);

        public Builder withRootCommand();

        public Builder whenLoaded(Consumer<Environment> var1);

        public Builder whenReady(Consumer<Environment> var1);

        public Builder whenReloaded(Consumer<Environment> var1);

        public void register(Object var1);
    }
}

