/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashMap;
import java.util.Map;
import org.anvilpowered.anvil.api.Environment;
import org.anvilpowered.anvil.api.EnvironmentManager;
import org.anvilpowered.anvil.api.Platform;
import org.anvilpowered.anvil.api.ServiceManager;
import org.anvilpowered.anvil.api.core.coremember.CoreMemberManager;
import org.anvilpowered.anvil.api.core.coremember.repository.CoreMemberRepository;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.misc.BindingExtensions;
import org.anvilpowered.anvil.base.plugin.BasePlugin;

public class Anvil
extends BasePlugin {
    static final Map<Long, Binding<?>> bindingsCache = new HashMap();
    protected static ServiceManager serviceManager;
    protected static Environment environment;

    Anvil(String name, Injector rootInjector, Module module) {
        super(name, rootInjector, module);
    }

    public static BindingExtensions getBindingExtensions(Binder binder) {
        return Anvil.getServiceManager().provide(BindingExtensions.class, binder);
    }

    public static Environment.Builder getEnvironmentBuilder() {
        return Anvil.getServiceManager().provide(Environment.Builder.class);
    }

    public static EnvironmentManager getEnvironmentManager() {
        return Anvil.getServiceManager().provide(EnvironmentManager.class);
    }

    public static Platform getPlatform() {
        return (Platform)environment.getInjector().getInstance(Platform.class);
    }

    public static Registry getRegistry() {
        return (Registry)environment.getInjector().getInstance(Registry.class);
    }

    public static CoreMemberManager getCoreMemberManager() {
        return (CoreMemberManager)environment.getInjector().getInstance(CoreMemberManager.class);
    }

    public static CoreMemberRepository<?, ?> getCoreMemberRepository() {
        return (CoreMemberRepository)Anvil.getCoreMemberManager().getPrimaryComponent();
    }

    public static ServiceManager getServiceManager() {
        if (serviceManager != null) {
            return serviceManager;
        }
        try {
            serviceManager = (ServiceManager)Class.forName("org.anvilpowered.anvil.api.ServiceManagerImpl").newInstance();
            return serviceManager;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Could not find ServiceManager implementation!", e);
        }
    }
}

