/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.plugin;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.Set;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.Environment;
import org.anvilpowered.anvil.api.plugin.Plugin;
import org.anvilpowered.anvil.api.plugin.PluginInfo;

public abstract class BasePlugin<TPluginContainer>
implements Plugin<TPluginContainer> {
    @Inject
    protected TPluginContainer pluginContainer;
    protected Environment environment;
    protected final String name;

    protected BasePlugin(String name, Injector rootInjector, Module module, Key<?> ... earlyServices) {
        this.name = name;
        this.createDefaultBuilder(name, rootInjector, module).addEarlyServices(earlyServices).register(this);
    }

    protected BasePlugin(String name, Injector rootInjector, Module module, Class<?> ... earlyServices) {
        this.name = name;
        this.createDefaultBuilder(name, rootInjector, module).addEarlyServices(earlyServices).register(this);
    }

    protected BasePlugin(String name, Injector rootInjector, Module module, TypeLiteral<?> ... earlyServices) {
        this.name = name;
        this.createDefaultBuilder(name, rootInjector, module).addEarlyServices(earlyServices).register(this);
    }

    protected BasePlugin(String name, Injector rootInjector, Module module, TypeToken<?> ... earlyServices) {
        this.name = name;
        this.createDefaultBuilder(name, rootInjector, module).addEarlyServices(earlyServices).register(this);
    }

    protected BasePlugin(String name, Injector rootInjector, Module module) {
        this.name = name;
        this.createDefaultBuilder(name, rootInjector, module).register(this);
    }

    protected BasePlugin(String name) {
        this.name = name;
    }

    protected Environment.Builder createDefaultBuilder(String name, Injector rootInjector, Module module) {
        Environment.Builder builder = Anvil.getEnvironmentBuilder().setName(name).setRootInjector(rootInjector).addModules(module).whenLoaded(this::whenLoaded).whenReady((Environment e) -> {
            this.environment = e;
        }).whenReady(this::whenReady).whenReloaded(this::whenReloaded);
        this.applyToBuilder(builder);
        return builder;
    }

    protected void applyToBuilder(Environment.Builder builder) {
    }

    private void sendLoaded(String status) {
        PluginInfo pluginInfo = this.environment.getPluginInfo();
        this.environment.getTextService().builder().append(pluginInfo.getPrefix()).green().append(pluginInfo.getVersion()).aqua().append(" by ").appendJoining((Object)", ", pluginInfo.getAuthors()).append(" - ", status, "!").sendToConsole();
    }

    protected void whenLoaded(Environment environment) {
    }

    protected void whenReady(Environment environment) {
        this.sendLoaded("Loaded");
    }

    protected void whenReloaded(Environment environment) {
        this.sendLoaded("Reloaded");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Plugin<TPluginContainer> o) {
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        return obj instanceof Plugin && this.name.equals(((Plugin)obj).getName());
    }

    @Override
    public TPluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public Environment getPrimaryEnvironment() {
        return this.environment;
    }

    @Override
    public Set<Environment> getAllEnvironments() {
        return Collections.singleton(this.environment);
    }
}

