/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.StoreTransaction;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.datastore.XodusRepository;
import org.anvilpowered.anvil.api.model.Mappable;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.api.util.TimeFormatService;
import org.anvilpowered.anvil.base.datastore.BaseXodusComponent;

public interface BaseXodusRepository<T extends ObjectWithId<EntityId>>
extends XodusRepository<T>,
BaseXodusComponent {
    @Override
    default public CompletableFuture<Optional<T>> insertOne(T item) {
        return CompletableFuture.supplyAsync(() -> (Optional)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            Entity entity = txn.newEntity(this.getTClass().getSimpleName());
            ((Mappable)((Object)item)).writeTo(entity);
            item.setId(entity.getId());
            return txn.commit() ? Optional.of(item) : Optional.empty();
        }));
    }

    @Override
    default public CompletableFuture<List<T>> insert(List<T> list) {
        return CompletableFuture.supplyAsync(() -> (List)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            list.forEach(item -> {
                Entity entity = txn.newEntity(this.getTClass().getSimpleName());
                ((Mappable)((Object)item)).writeTo(entity);
                item.setId(entity.getId());
            });
            txn.commit();
            return list;
        }));
    }

    @Override
    default public CompletableFuture<List<T>> getAll(Function<? super StoreTransaction, ? extends Iterable<Entity>> query) {
        return CompletableFuture.supplyAsync(() -> (List)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInReadonlyTransaction(txn -> StreamSupport.stream(((Iterable)query.apply(txn)).spliterator(), false).map(e -> {
            Object item = this.generateEmpty();
            ((Mappable)item).readFrom(e);
            return item;
        }).collect(Collectors.toList())));
    }

    @Override
    default public CompletableFuture<List<T>> getAll() {
        return this.getAll(txn -> txn.getAll(this.getTClass().getSimpleName()));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(Function<? super StoreTransaction, ? extends Iterable<Entity>> query) {
        return CompletableFuture.supplyAsync(() -> (Optional)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInReadonlyTransaction(txn -> {
            Iterator iterator = ((Iterable)query.apply(txn)).iterator();
            if (iterator.hasNext()) {
                Object item = this.generateEmpty();
                ((Mappable)item).readFrom(iterator.next());
                return Optional.of(item);
            }
            return Optional.empty();
        }));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(EntityId id) {
        return CompletableFuture.supplyAsync(() -> (Optional)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInReadonlyTransaction(txn -> {
            Entity entity;
            try {
                entity = txn.getEntity(id);
            }
            catch (EntityRemovedInDatabaseException ignored) {
                return Optional.empty();
            }
            Object item = this.generateEmpty();
            ((Mappable)item).readFrom(entity);
            return Optional.of(item);
        }));
    }

    @Override
    default public CompletableFuture<Optional<T>> getOne(Instant createdUtc) {
        return CompletableFuture.supplyAsync(() -> (Optional)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInReadonlyTransaction(txn -> {
            Entity entity;
            try {
                Iterator<Entity> it = this.asQuery(createdUtc).apply(txn).iterator();
                if (!it.hasNext()) {
                    return Optional.empty();
                }
                entity = it.next();
            }
            catch (EntityRemovedInDatabaseException ignored) {
                return Optional.empty();
            }
            Object item = this.generateEmpty();
            ((Mappable)item).readFrom(entity);
            return Optional.of(item);
        }));
    }

    @Override
    default public CompletableFuture<List<EntityId>> getAllIds() {
        return CompletableFuture.supplyAsync(() -> (List)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInReadonlyTransaction(txn -> {
            EntityIterable iterable = txn.getAll(this.getTClass().getSimpleName());
            EntityIterator iterator = iterable.iterator();
            long roughCount = iterable.getRoughCount();
            int buffer = 50;
            int listSize = roughCount > 2147483597L ? 2147483597 : (int)(roughCount + 50L);
            ArrayList<EntityId> list = new ArrayList<EntityId>(listSize);
            while (iterator.hasNext()) {
                list.add(iterator.nextId());
            }
            if (iterator.shouldBeDisposed()) {
                iterator.dispose();
            }
            return list;
        }));
    }

    @Override
    default public CompletableFuture<Boolean> delete(Function<? super StoreTransaction, ? extends Iterable<Entity>> query) {
        return CompletableFuture.supplyAsync(() -> (Boolean)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            boolean success = false;
            for (Entity entity : (Iterable)query.apply(txn)) {
                if (!entity.delete()) continue;
                success = true;
            }
            return txn.commit() && success;
        }));
    }

    @Override
    default public CompletableFuture<Boolean> deleteOne(EntityId id) {
        return CompletableFuture.supplyAsync(() -> (Boolean)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> txn.getEntity(id).delete() && txn.commit()));
    }

    @Override
    default public CompletableFuture<Boolean> deleteOne(Instant createdUtc) {
        return CompletableFuture.supplyAsync(() -> (Boolean)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            Iterator<Entity> it = this.asQuery(createdUtc).apply(txn).iterator();
            return it.hasNext() && it.next().delete() && txn.commit();
        }));
    }

    @Override
    default public CompletableFuture<Boolean> update(Function<? super StoreTransaction, ? extends Iterable<Entity>> query, Consumer<? super Entity> update) {
        return CompletableFuture.supplyAsync(() -> (Boolean)((PersistentEntityStore)this.getDataStoreContext().getDataStore()).computeInTransaction(txn -> {
            ((Iterable)query.apply(txn)).forEach(e -> {
                update.accept((Entity)e);
                Instant now = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
                e.setProperty("updatedUtcSeconds", (Comparable)Long.valueOf(now.getEpochSecond()));
                e.setProperty("updatedUtcNanos", (Comparable)Integer.valueOf(now.getNano()));
            });
            return txn.commit();
        }));
    }

    @Override
    default public CompletableFuture<Boolean> update(Optional<Function<? super StoreTransaction, ? extends Iterable<Entity>>> optionalQuery, Consumer<? super Entity> update) {
        return optionalQuery.map(q -> this.update((Function<? super StoreTransaction, ? extends Iterable<Entity>>)q, (Consumer<? super Entity>)((Consumer<Entity>)update))).orElse(CompletableFuture.completedFuture(false));
    }

    @Override
    default public Function<? super StoreTransaction, ? extends Iterable<Entity>> asQuery(EntityId id) {
        return txn -> Collections.singletonList(txn.getEntity(id));
    }

    @Override
    default public Function<? super StoreTransaction, ? extends Iterable<Entity>> asQuery(Instant createdUtc) {
        return txn -> txn.find(this.getTClass().getSimpleName(), "createdUtcSeconds", (Comparable)Long.valueOf(createdUtc.getEpochSecond())).union(txn.find(this.getTClass().getSimpleName(), "createdUtcNanos", (Comparable)Integer.valueOf(createdUtc.getNano())));
    }

    @Override
    default public Optional<Function<? super StoreTransaction, ? extends Iterable<Entity>>> asQueryForIdOrTime(String idOrTime) {
        return this.parse(idOrTime).map(entityId -> Optional.of(this.asQuery((EntityId)entityId))).orElseGet(() -> ((TimeFormatService)Anvil.getEnvironmentManager().getCoreEnvironment().getInjector().getInstance(TimeFormatService.class)).parseInstant(idOrTime).map(Instant::getEpochSecond).map(s -> txn -> txn.find(this.getTClass().getSimpleName(), "createdUtcSeconds", (Comparable)s)));
    }
}

