/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.datastore.StorageService;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.api.util.TimeFormatService;

public interface BaseStorageService<TKey, T extends ObjectWithId<TKey>, TDataStore>
extends StorageService<TKey, T, TDataStore> {
    @Override
    default public T generateEmpty() {
        Class tClass = this.getTClass();
        try {
            return (T)((ObjectWithId)tClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            String message = "There was an error creating an instance of " + tClass.getName() + "! Make sure it has an accessible no-args constructor!";
            System.err.println(message);
            throw new IllegalStateException(message, e);
        }
    }

    @Override
    default public CompletableFuture<Optional<T>> parseAndGetOne(Object idOrTime) {
        return this.parse(idOrTime).map(this::getOne).orElseGet(() -> ((TimeFormatService)Anvil.getEnvironmentManager().getCoreEnvironment().getInjector().getInstance(TimeFormatService.class)).parseInstant(idOrTime.toString()).map(this::getOne).orElse(CompletableFuture.completedFuture(Optional.empty())));
    }

    @Override
    default public CompletableFuture<Boolean> parseAndDeleteOne(Object idOrTime) {
        return this.parse(idOrTime).map(this::deleteOne).orElseGet(() -> ((TimeFormatService)Anvil.getEnvironmentManager().getCoreEnvironment().getInjector().getInstance(TimeFormatService.class)).parseInstant(idOrTime.toString()).map(this::deleteOne).orElse(CompletableFuture.completedFuture(false)));
    }
}

