/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.util.Optional;
import org.anvilpowered.anvil.api.datastore.Component;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;

public interface BaseMongoComponent
extends Component<ObjectId, Datastore> {
    @Override
    default public ObjectId parseUnsafe(Object object) {
        if (object instanceof ObjectId) {
            return (ObjectId)object;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            if (optional.isPresent()) {
                return this.parseUnsafe(optional.get());
            }
            throw new IllegalArgumentException("Error while parsing " + object + ". Optional not present");
        }
        String string = object.toString();
        if (ObjectId.isValid((String)string)) {
            return new ObjectId(string);
        }
        throw new IllegalArgumentException("Error while parsing " + object + ". Not a valid ObjectId");
    }
}

