/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import com.google.common.reflect.TypeToken;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Objects;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.Component;
import org.anvilpowered.anvil.api.datastore.Manager;
import org.anvilpowered.anvil.api.misc.BindingExtensions;

public abstract class BaseManager<C extends Component<?, ?>>
implements Manager<C> {
    protected Registry registry;
    @Inject
    private Injector injector;
    private C currentComponent;

    protected BaseManager(Registry registry) {
        this.registry = registry;
        registry.whenLoaded(this::registryLoaded);
    }

    private void registryLoaded() {
        this.currentComponent = null;
    }

    private void loadComponent() {
        String dataStoreName = Anvil.resolveForSharedEnvironment(Keys.DATA_STORE_NAME, this.registry).toLowerCase(Locale.ENGLISH);
        try {
            this.currentComponent = (Component)this.injector.getInstance(Key.get(BindingExtensions.getTypeLiteral(new TypeToken<C>(this.getClass()){}), (Annotation)Names.named((String)dataStoreName)));
        }
        catch (ConfigurationException | IllegalStateException e) {
            String message = "Anvil: Could not find requested data store: \"" + dataStoreName + "\". Did you bind it correctly?";
            System.err.println(message);
            throw new IllegalStateException(message, e);
        }
    }

    @Override
    public C getPrimaryComponent() {
        try {
            if (this.currentComponent == null) {
                this.loadComponent();
            }
            return (C)((Component)Objects.requireNonNull(this.currentComponent, "An error occurred while loading current component"));
        }
        catch (RuntimeException e) {
            String message = "Anvil: DataStoreName has not been loaded yet! Make sure your Registry and ConfigurationService implementations are annotated with @Singleton!";
            System.err.println(message);
            throw new IllegalStateException(message, e);
        }
    }
}

