/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.datastore;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.CacheService;
import org.anvilpowered.anvil.api.datastore.DataStoreContext;
import org.anvilpowered.anvil.api.model.ObjectWithId;
import org.anvilpowered.anvil.base.datastore.BaseComponent;
import org.anvilpowered.anvil.base.datastore.BaseStorageService;

public abstract class BaseCacheService<TKey, T extends ObjectWithId<TKey>, TDataStore>
extends BaseComponent<TKey, TDataStore>
implements CacheService<TKey, T, TDataStore>,
BaseStorageService<TKey, T, TDataStore> {
    protected Registry registry;
    protected ConcurrentMap<T, Long> cache;
    private Integer timeoutSeconds;

    protected BaseCacheService(DataStoreContext<TKey, TDataStore> dataStoreContext, Registry registry) {
        super(dataStoreContext);
        this.registry = registry;
        registry.whenLoaded(this::registryLoaded);
        this.cache = new ConcurrentHashMap<T, Long>();
    }

    private void registryLoaded() {
        this.stopCacheInvalidationTask();
        Integer intervalSeconds = this.registry.getOrDefault(Keys.CACHE_INVALIDATION_INTERVAL_SECONDS);
        this.timeoutSeconds = this.registry.getOrDefault(Keys.CACHE_INVALIDATION_TIMOUT_SECONDS);
        this.startCacheInvalidationTask(intervalSeconds);
    }

    @Override
    public Runnable getCacheInvalidationTask() {
        return () -> {
            ArrayList<ObjectWithId> toRemove = new ArrayList<ObjectWithId>();
            for (ObjectWithId t : this.getAllAsSet()) {
                if (System.currentTimeMillis() - (Long)this.cache.get(t) <= (long)this.timeoutSeconds.intValue() * 1000L) continue;
                toRemove.add(t);
            }
            toRemove.forEach(this::delete);
        };
    }

    @Override
    public Set<T> getAllAsSet() {
        return this.cache.keySet();
    }

    @Override
    public CompletableFuture<Optional<T>> insertOne(T t) {
        return CompletableFuture.supplyAsync(() -> {
            if (t == null) {
                return Optional.empty();
            }
            this.cache.put(t, System.currentTimeMillis());
            return Optional.of(t);
        });
    }

    @Override
    public CompletableFuture<List<T>> insert(List<T> list) {
        return CompletableFuture.supplyAsync(() -> list.stream().map(t -> this.insertOne(t).join().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Optional<T>> getOne(TKey id) {
        return CompletableFuture.supplyAsync(() -> this.getOne((? super T dbo) -> dbo.getId().equals(id)));
    }

    @Override
    public CompletableFuture<Boolean> deleteOne(TKey id) {
        return CompletableFuture.supplyAsync(() -> this.deleteOne((? super T dbo) -> dbo.getId().equals(id)).isPresent());
    }

    @Override
    public CompletableFuture<List<TKey>> getAllIds() {
        return CompletableFuture.supplyAsync(() -> this.cache.keySet().stream().map(ObjectWithId::getId).collect(Collectors.toList()));
    }

    @Override
    public Optional<T> deleteOne(Predicate<? super T> predicate) {
        return this.getOne(predicate).flatMap(this::delete);
    }

    @Override
    public Optional<T> delete(T t) {
        return this.cache.remove(t) == null ? Optional.empty() : Optional.of(t);
    }

    @Override
    public List<T> delete(Predicate<? super T> predicate) {
        return this.cache.keySet().stream().filter(predicate).filter(t -> this.cache.remove(t) != null).collect(Collectors.toList());
    }

    @Override
    public List<T> getAll(Predicate<? super T> predicate) {
        return this.getAllAsSet().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public Optional<T> getOne(Predicate<? super T> predicate) {
        return this.getAll(predicate).stream().findAny();
    }
}

