/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.data.registry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import org.anvilpowered.anvil.api.data.config.ConfigurationService;
import org.anvilpowered.anvil.api.data.key.Key;
import org.anvilpowered.anvil.base.data.registry.BaseRegistry;

@Singleton
public class BaseExtendedRegistry
extends BaseRegistry {
    @Inject
    protected ConfigurationService configurationService;

    @Override
    public <T> Optional<T> get(Key<T> key) {
        Optional<T> result = super.get(key);
        return result.isPresent() ? result : this.configurationService.get(key);
    }

    @Override
    public <T> T getDefault(Key<T> key) {
        T result = null;
        try {
            result = super.getDefault(key);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return result == null ? (T)this.configurationService.getDefault(key) : result;
    }

    @Override
    public void load() {
        this.configurationService.load();
        super.load();
    }

    @Override
    public String toString() {
        if (this.configurationService == null) {
            return super.toString();
        }
        return super.toString() + "\n" + this.configurationService;
    }
}

