/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.base.data.config;

import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.anvilpowered.anvil.api.data.config.ConfigurationService;
import org.anvilpowered.anvil.api.data.key.Key;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.base.data.registry.BaseRegistry;

@Singleton
public class BaseConfigurationService
extends BaseRegistry
implements ConfigurationService {
    protected ConfigurationLoader<CommentedConfigurationNode> configLoader;
    private CommentedConfigurationNode rootConfigurationNode;
    private final Map<Key<?>, Map<Predicate<Object>, Function<Object, Object>>> verificationMap;
    private final Map<Key<?>, String> nodeNameMap;
    private final Map<Key<?>, String> nodeDescriptionMap;
    private boolean configValuesEdited;
    private boolean isWithDataStore = false;

    @Inject
    public BaseConfigurationService(ConfigurationLoader<CommentedConfigurationNode> configLoader) {
        this.configLoader = configLoader;
        this.verificationMap = new HashMap();
        this.nodeNameMap = new HashMap();
        this.nodeDescriptionMap = new HashMap();
    }

    protected void withCore() {
        this.setName(Keys.SERVER_NAME, "server.name");
        this.setDescription(Keys.SERVER_NAME, "\nServer name");
    }

    private void withDataStoreCore0() {
        this.setName(Keys.DATA_DIRECTORY, "datastore.dataDirectory");
        this.setName(Keys.DATA_STORE_NAME, "datastore.dataStoreName");
        this.setDescription(Keys.DATA_DIRECTORY, "\nDirectory for extra data\nPlease note that it is not recommended to change this value from the original");
        this.setDescription(Keys.DATA_STORE_NAME, "\nDetermines which storage option to use");
    }

    protected void withDataStoreCore() {
        if (this.isWithDataStore) {
            return;
        }
        this.isWithDataStore = true;
        this.withDataStoreCore0();
    }

    protected void withDataStore() {
        if (this.isWithDataStore) {
            return;
        }
        this.isWithDataStore = true;
        this.withDataStoreCore0();
        this.setName(Keys.USE_SHARED_CREDENTIALS, "datastore.anvil.useSharedCredentials");
        this.setName(Keys.USE_SHARED_ENVIRONMENT, "datastore.anvil.useSharedEnvironment");
        this.setDescription(Keys.USE_SHARED_CREDENTIALS, "\nWhether to use Anvil's shared credentials.\nIf enabled, the following datastore settings will be inherited from Anvil's config (Requires useSharedEnvironment)\n\t- mongodb.authDb\n\t- mongodb.connectionString\n\t- mongodb.password\n\t- mongodb.username\n\t- mongodb.useAuth\n\t- mongodb.useConnectionString\n\t- mongodb.useSrv\nPlease note: If this is enabled, the values for above settings in this config file have no effect");
        this.setDescription(Keys.USE_SHARED_ENVIRONMENT, "\nWhether to use Anvil's shared environment.\nIf enabled, the following datastore settings will be inherited from Anvil's config\n\t- mongodb.hostname\n\t- mongodb.port\nPlease note: If this is enabled, the values for above settings in this config file have no effect");
    }

    protected void withMongoDB() {
        this.withDataStore();
        this.setName(Keys.MONGODB_CONNECTION_STRING, "datastore.mongodb.connectionString");
        this.setName(Keys.MONGODB_HOSTNAME, "datastore.mongodb.hostname");
        this.setName(Keys.MONGODB_PORT, "datastore.mongodb.port");
        this.setName(Keys.MONGODB_DBNAME, "datastore.mongodb.dbname");
        this.setName(Keys.MONGODB_USERNAME, "datastore.mongodb.username");
        this.setName(Keys.MONGODB_PASSWORD, "datastore.mongodb.password");
        this.setName(Keys.MONGODB_AUTH_DB, "datastore.mongodb.authDb");
        this.setName(Keys.MONGODB_USE_AUTH, "datastore.mongodb.useAuth");
        this.setName(Keys.MONGODB_USE_SRV, "datastore.mongodb.useSrv");
        this.setName(Keys.MONGODB_USE_CONNECTION_STRING, "datastore.mongodb.useConnectionString");
        this.setDescription(Keys.MONGODB_CONNECTION_STRING, "\n(Advanced) You will probably not need to use this.\nCustom MongoDB connection string that will used instead of the connection info and credentials below\nWill only be used if useConnectionString=true");
        this.setDescription(Keys.MONGODB_HOSTNAME, "\nMongoDB hostname");
        this.setDescription(Keys.MONGODB_PORT, "\nMongoDB port");
        this.setDescription(Keys.MONGODB_DBNAME, "\nMongoDB database name");
        this.setDescription(Keys.MONGODB_USERNAME, "\nMongoDB username");
        this.setDescription(Keys.MONGODB_PASSWORD, "\nMongoDB password");
        this.setDescription(Keys.MONGODB_AUTH_DB, "\nMongoDB database to use for authentication");
        this.setDescription(Keys.MONGODB_USE_AUTH, "\nWhether to use authentication (username/password) for MongoDB connection");
        this.setDescription(Keys.MONGODB_USE_SRV, "\nWhether to interpret the MongoDB hostname as an SRV record");
        this.setDescription(Keys.MONGODB_USE_CONNECTION_STRING, "\n(Advanced) You will probably not need to use this.\nWhether to use the connection string provided instead of the normal connection info and credentials\nOnly use this if you know what you are doing!\nPlease note that this plugin will inherit both useConnectionString and connectionString from\nAnvil if and only if useSharedEnvironment and useSharedCredentials are both true");
    }

    protected void withRedis() {
        this.setName(Keys.REDIS_HOSTNAME, "datastore.redis.hostname");
        this.setName(Keys.REDIS_PORT, "datastore.redis.port");
        this.setName(Keys.REDIS_PASSWORD, "datastore.redis.password");
        this.setName(Keys.REDIS_USE_AUTH, "datastore.redis.useAuth");
        this.setDescription(Keys.REDIS_HOSTNAME, "\nRedis hostname");
        this.setDescription(Keys.REDIS_PORT, "\nRedis Port");
        this.setDescription(Keys.REDIS_PASSWORD, "\nRedis password");
        this.setDescription(Keys.REDIS_USE_AUTH, "\nWhether to use authentication (password) for Redis connection");
    }

    protected void withProxyMode() {
        this.setName(Keys.PROXY_MODE, "server.proxyMode");
        this.setDescription(Keys.PROXY_MODE, "\nEnable this if your server is running behind a proxy\nIf true, this setting disables the join and chat listeners\nto prevent conflicts with the proxy's listeners.");
    }

    protected void withDefault() {
        this.withCore();
        this.withMongoDB();
    }

    protected void withAll() {
        this.withDefault();
        this.withRedis();
        this.withProxyMode();
    }

    protected <T> void setVerification(Key<T> key, Map<Predicate<T>, Function<T, T>> verification) {
        this.verificationMap.put(key, verification);
    }

    protected void setName(Key<?> key, String name) {
        this.nodeNameMap.put(key, name);
    }

    protected void setDescription(Key<?> key, String description) {
        this.nodeDescriptionMap.put(key, description);
    }

    @Override
    public <T> void set(Key<T> key, T value) {
        super.set(key, value);
        this.configValuesEdited = true;
    }

    @Override
    public <T> void remove(Key<T> key) {
        super.remove(key);
        this.configValuesEdited = true;
    }

    @Override
    public <T> void transform(Key<T> key, BiFunction<? super Key<T>, ? super T, ? extends T> transformer) {
        super.transform(key, transformer);
        this.configValuesEdited = true;
    }

    @Override
    public <T> void transform(Key<T> key, Function<? super T, ? extends T> transformer) {
        super.transform(key, transformer);
        this.configValuesEdited = true;
    }

    @Override
    public <T> void addToCollection(Key<? extends Collection<T>> key, T value) {
        super.addToCollection(key, value);
        this.configValuesEdited = true;
    }

    @Override
    public <T> void removeFromCollection(Key<? extends Collection<T>> key, T value) {
        super.removeFromCollection(key, value);
        this.configValuesEdited = true;
    }

    @Override
    public <K, T> void putInMap(Key<? extends Map<K, T>> key, K mapKey, T mapValue) {
        super.putInMap(key, mapKey, mapValue);
        this.configValuesEdited = true;
    }

    @Override
    public <K, T> void removeFromMap(Key<? extends Map<K, T>> key, K mapKey) {
        super.removeFromMap(key, mapKey);
        this.configValuesEdited = true;
    }

    @Override
    public void load() {
        this.initConfigMaps();
        super.load();
    }

    @Override
    public boolean save() {
        if (this.configValuesEdited) {
            for (Map.Entry<Key<?>, String> entry : this.nodeNameMap.entrySet()) {
                CommentedConfigurationNode node = this.fromString(entry.getValue());
                node.setValue(this.getUnsafe(entry.getKey()));
            }
            try {
                this.configLoader.save((ConfigurationNode)this.rootConfigurationNode);
                this.configValuesEdited = false;
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private CommentedConfigurationNode fromString(String name) {
        String[] path = name.split("[.]");
        CommentedConfigurationNode node = this.rootConfigurationNode;
        for (String s : path) {
            node = node.getNode(new Object[]{s});
        }
        return node;
    }

    private <T> void setNodeDefault(CommentedConfigurationNode node, Key<T> key) throws ObjectMappingException {
        node.setValue(key, this.getDefault(key));
    }

    private void initConfigMaps() {
        try {
            this.rootConfigurationNode = (CommentedConfigurationNode)this.configLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int updatedCount = 0;
        for (Map.Entry<Key<?>, String> entry : this.nodeNameMap.entrySet()) {
            Key<?> key = entry.getKey();
            CommentedConfigurationNode node = this.fromString(entry.getValue());
            if (node.isVirtual()) {
                try {
                    this.setNodeDefault(node, key);
                    ++updatedCount;
                }
                catch (ObjectMappingException e) {
                    e.printStackTrace();
                }
            } else {
                boolean[] modified = new boolean[]{false};
                this.initConfigValue(key, node, modified);
                if (modified[0]) {
                    ++updatedCount;
                }
            }
            if (!node.isVirtual() && node.getComment().isPresent()) continue;
            node.setComment(this.nodeDescriptionMap.get(key));
            ++updatedCount;
        }
        if (updatedCount > 0) {
            try {
                this.configLoader.save((ConfigurationNode)this.rootConfigurationNode);
                this.configValuesEdited = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> T initConfigValue(TypeToken<T> typeToken, CommentedConfigurationNode node, boolean[] modified) {
        if (typeToken instanceof Key && typeToken.isSubtypeOf(List.class)) {
            try {
                Method getMethod = List.class.getMethod("get", Integer.TYPE);
                Invokable invokable = typeToken.method(getMethod);
                List list = this.verify(this.verificationMap.get(typeToken), node.getList(invokable.getReturnType()), node, modified);
                this.set((Key)typeToken, list);
                return (T)list;
            }
            catch (IllegalArgumentException | NoSuchMethodException | ObjectMappingException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (typeToken.isSubtypeOf(Map.class)) {
            try {
                Method getMethod = Map.class.getMethod("get", Object.class);
                Invokable invokable = typeToken.method(getMethod);
                TypeToken subType = invokable.getReturnType();
                HashMap<Object, T> result = new HashMap<Object, T>();
                for (Map.Entry entry : node.getChildrenMap().entrySet()) {
                    result.put(((CommentedConfigurationNode)entry.getValue()).getKey(), this.initConfigValue(subType, (CommentedConfigurationNode)entry.getValue(), modified));
                }
                if (typeToken instanceof Key) {
                    Key key = (Key)typeToken;
                    HashMap map = this.verify(this.verificationMap.get(key), result, node, modified);
                    this.set(key, map);
                }
                return (T)result;
            }
            catch (IllegalArgumentException | NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (typeToken instanceof Key) {
            try {
                Object value = node.getValue(typeToken);
                Key key = (Key)typeToken;
                this.set(key, this.verify(this.verificationMap.get(key), value, node, modified));
                return (T)value;
            }
            catch (ClassCastException | ObjectMappingException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return (T)node.getValue(typeToken);
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T> T verify(Map<Predicate<T>, Function<T, T>> verificationMap, T value, CommentedConfigurationNode node, boolean[] modified) {
        if (verificationMap == null) {
            return value;
        }
        T result = value;
        for (Map.Entry<Predicate<T>, Function<T, T>> entry : verificationMap.entrySet()) {
            if (!entry.getKey().test(result)) continue;
            modified[0] = true;
            result = entry.getValue().apply(result);
        }
        if (modified[0]) {
            node.setValue(result);
        }
        return result;
    }
}

