/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.util;

import java.net.URL;
import java.util.Optional;
import java.util.function.Consumer;
import org.anvilpowered.anvil.api.util.Result;
import org.jetbrains.annotations.Nullable;

public interface TextService<TString, TCommandSource>
extends Result<TString, String> {
    public Builder<TString, TCommandSource> builder();

    public PaginationBuilder<TString, TCommandSource> paginationBuilder();

    default public TString of(Object ... contents) {
        return this.builder().append(contents).build();
    }

    default public TString of(CharSequence ... contents) {
        return this.builder().append(contents).build();
    }

    public void send(TString var1, TCommandSource var2);

    default public void sendToConsole(TString text) {
        this.send(text, this.getConsole());
    }

    public TCommandSource getConsole();

    public TString deserialize(String var1);

    public String serialize(TString var1);

    public String serializePlain(TString var1);

    public String toPlain(String var1);

    public int lineCount(@Nullable TString var1);

    default public int length(@Nullable TString text) {
        return text == null ? -1 : this.serializePlain(text).length();
    }

    public static interface Pagination<TString, TCommandSource> {
        public Iterable<TString> getContents();

        public Optional<TString> getTitle();

        public Optional<TString> getHeader();

        public Optional<TString> getFooter();

        public TString getPadding();

        public int getLinesPerPage();

        public void sendTo(TCommandSource var1);

        public void sendToConsole();
    }

    public static interface PaginationBuilder<TString, TCommandSource> {
        public PaginationBuilder<TString, TCommandSource> contents(TString ... var1);

        public PaginationBuilder<TString, TCommandSource> contents(Iterable<TString> var1);

        public PaginationBuilder<TString, TCommandSource> title(@Nullable TString var1);

        public PaginationBuilder<TString, TCommandSource> title(@Nullable Builder<TString, TCommandSource> var1);

        public PaginationBuilder<TString, TCommandSource> header(@Nullable TString var1);

        public PaginationBuilder<TString, TCommandSource> header(@Nullable Builder<TString, TCommandSource> var1);

        public PaginationBuilder<TString, TCommandSource> footer(@Nullable TString var1);

        public PaginationBuilder<TString, TCommandSource> footer(@Nullable Builder<TString, TCommandSource> var1);

        public PaginationBuilder<TString, TCommandSource> padding(TString var1);

        public PaginationBuilder<TString, TCommandSource> padding(Builder<TString, TCommandSource> var1);

        public PaginationBuilder<TString, TCommandSource> linesPerPage(int var1);

        public Pagination<TString, TCommandSource> build();
    }

    public static interface Builder<TString, TCommandSource> {
        public Builder<TString, TCommandSource> aqua();

        public Builder<TString, TCommandSource> black();

        public Builder<TString, TCommandSource> blue();

        public Builder<TString, TCommandSource> dark_aqua();

        public Builder<TString, TCommandSource> dark_blue();

        public Builder<TString, TCommandSource> dark_gray();

        public Builder<TString, TCommandSource> dark_green();

        public Builder<TString, TCommandSource> dark_purple();

        public Builder<TString, TCommandSource> dark_red();

        public Builder<TString, TCommandSource> gold();

        public Builder<TString, TCommandSource> gray();

        public Builder<TString, TCommandSource> green();

        public Builder<TString, TCommandSource> light_purple();

        public Builder<TString, TCommandSource> red();

        public Builder<TString, TCommandSource> reset();

        public Builder<TString, TCommandSource> white();

        public Builder<TString, TCommandSource> yellow();

        public Builder<TString, TCommandSource> bold();

        public Builder<TString, TCommandSource> italic();

        public Builder<TString, TCommandSource> obfuscated();

        public Builder<TString, TCommandSource> strikethrough();

        public Builder<TString, TCommandSource> underlined();

        public Builder<TString, TCommandSource> append(Object ... var1);

        public Builder<TString, TCommandSource> append(CharSequence ... var1);

        public Builder<TString, TCommandSource> appendCount(int var1, Object ... var2);

        public Builder<TString, TCommandSource> appendCount(int var1, CharSequence ... var2);

        public Builder<TString, TCommandSource> appendWithPaddingLeft(int var1, Object var2, Object ... var3);

        public Builder<TString, TCommandSource> appendWithPaddingLeft(int var1, Object var2, CharSequence ... var3);

        public Builder<TString, TCommandSource> appendWithPaddingAround(int var1, Object var2, Object ... var3);

        public Builder<TString, TCommandSource> appendWithPaddingAround(int var1, Object var2, CharSequence ... var3);

        public Builder<TString, TCommandSource> appendWithPaddingRight(int var1, Object var2, Object ... var3);

        public Builder<TString, TCommandSource> appendWithPaddingRight(int var1, Object var2, CharSequence ... var3);

        public Builder<TString, TCommandSource> appendIf(boolean var1, Object ... var2);

        public Builder<TString, TCommandSource> appendIf(boolean var1, CharSequence ... var2);

        public Builder<TString, TCommandSource> appendJoining(Object var1, Object ... var2);

        public Builder<TString, TCommandSource> appendJoining(Object var1, CharSequence ... var2);

        public Builder<TString, TCommandSource> appendJoiningIf(boolean var1, Object var2, Object ... var3);

        public Builder<TString, TCommandSource> appendJoiningIf(boolean var1, Object var2, CharSequence ... var3);

        public Builder<TString, TCommandSource> onHoverShowText(TString var1);

        public Builder<TString, TCommandSource> onHoverShowText(Builder<TString, TCommandSource> var1);

        public Builder<TString, TCommandSource> onClickSuggestCommand(String var1);

        public Builder<TString, TCommandSource> onClickRunCommand(String var1);

        public Builder<TString, TCommandSource> onClickExecuteCallback(Consumer<TCommandSource> var1);

        public Builder<TString, TCommandSource> onClickOpenUrl(URL var1);

        public Builder<TString, TCommandSource> onClickOpenUrl(String var1);

        public TString build();

        public void sendTo(TCommandSource var1);

        public void sendToConsole();
    }
}

