/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.datastore;

import com.google.inject.Inject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import org.anvilpowered.anvil.api.Anvil;
import org.anvilpowered.anvil.api.data.key.Keys;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.DataStoreContext;

public final class SqlContext
extends DataStoreContext<UUID, HikariDataSource> {
    @Inject
    public SqlContext(Registry registry) {
        super(registry);
    }

    @Override
    public HikariDataSource loadDataStore() {
        String hostname = (String)Anvil.resolveForSharedEnvironment(Keys.resolveUnsafe("MARIADB_HOSTNAME"), this.registry);
        int port = (Integer)Anvil.resolveForSharedEnvironment(Keys.resolveUnsafe("MARIADB_PORT"), this.registry);
        String username = (String)Anvil.resolveForSharedEnvironment(Keys.resolveUnsafe("MARIADB_USERNAME"), this.registry);
        String password = (String)Anvil.resolveForSharedEnvironment(Keys.resolveUnsafe("MARIADB_PASSWORD"), this.registry);
        boolean useAuth = (Boolean)Anvil.resolveForSharedEnvironment(Keys.resolveUnsafe("MARIADB_USE_AUTH"), this.registry);
        HikariConfig config = new HikariConfig();
        if (useAuth) {
            String encodedPassword = password;
            try {
                encodedPassword = URLEncoder.encode(password, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            config.setPassword(encodedPassword);
        }
        config.setJdbcUrl("jdbc:mariadb://" + hostname + ":" + port);
        config.setUsername(username);
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.setDriverClassName("org.mariadb.jdbc.Driver");
        config.setMaximumPoolSize(20);
        return new HikariDataSource(config);
    }

    @Override
    protected void closeConnection(HikariDataSource dataStore) {
        dataStore.close();
    }
}

