/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.datastore;

import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.anvilpowered.anvil.api.data.registry.Registry;
import org.anvilpowered.anvil.api.datastore.ConnectionClosedListener;
import org.anvilpowered.anvil.api.datastore.ConnectionOpenedListener;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public abstract class DataStoreContext<TKey, TDataStore> {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final List<ConnectionOpenedListener<TDataStore>> connectionOpenedListeners = new ArrayList<ConnectionOpenedListener<TDataStore>>();
    private final List<ConnectionClosedListener<TDataStore>> connectionClosedListeners = new ArrayList<ConnectionClosedListener<TDataStore>>();
    protected final Registry registry;
    private TDataStore dataStore;
    private Class<?>[] entityClasses;
    private Class<TKey> tKeyClass;
    @Inject(optional=true)
    private ClassLoader classLoader;

    protected DataStoreContext(Registry registry) {
        this.registry = registry;
        registry.whenLoaded(this::registryLoaded);
    }

    protected void registryLoaded() {
        this.requestCloseConnection();
        this.dataStore = null;
    }

    protected abstract TDataStore loadDataStore();

    public TDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.loadDataStore();
            this.notifyConnectionOpenedListeners(this.dataStore);
        }
        return Objects.requireNonNull(this.dataStore, "An error occurred while loading datastore");
    }

    @SafeVarargs
    protected final Class<?>[] calculateEntityClasses(String baseScanPackage, Class<? extends Annotation> ... entityAnnotations) {
        if (entityAnnotations.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Reflections reflections = new Reflections(new Object[]{baseScanPackage, new TypeAnnotationsScanner(), new SubTypesScanner(), this.classLoader});
        Set types = reflections.getTypesAnnotatedWith(entityAnnotations[0]);
        for (int i = 1; i < entityAnnotations.length; ++i) {
            types.addAll(reflections.getTypesAnnotatedWith(entityAnnotations[i]));
        }
        this.entityClasses = types.toArray(EMPTY_CLASS_ARRAY);
        return this.entityClasses;
    }

    public final Class<?>[] getEntityClasses() {
        return this.entityClasses;
    }

    public final Optional<Class<?>> getEntityClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = this.getEntityClassUnsafe(name);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return Optional.ofNullable(clazz);
    }

    public final Class<?> getEntityClassUnsafe(String name) {
        this.getDataStore();
        String n = name.toLowerCase(Locale.ENGLISH);
        for (Class<?> entityClass : this.entityClasses) {
            if (!entityClass.getSimpleName().toLowerCase(Locale.ENGLISH).contains(n)) continue;
            return entityClass;
        }
        throw new IllegalStateException("Could not find EntityClass for " + name);
    }

    protected final void setTKeyClass(Class<TKey> tKeyClass) {
        this.tKeyClass = tKeyClass;
    }

    public final Class<TKey> getTKeyClass() {
        return this.tKeyClass;
    }

    protected abstract void closeConnection(TDataStore var1);

    protected final void requestCloseConnection() {
        if (this.dataStore != null) {
            this.notifyConnectionClosedListeners(this.dataStore);
            this.closeConnection(this.dataStore);
            this.dataStore = null;
        }
    }

    private void notifyConnectionOpenedListeners(TDataStore dataStore) {
        this.connectionOpenedListeners.forEach(listener -> listener.loaded(dataStore));
    }

    public final void addConnectionOpenedListener(ConnectionOpenedListener<TDataStore> connectionOpenedListener) {
        this.connectionOpenedListeners.add(connectionOpenedListener);
    }

    public final void removeConnectionOpenedListener(ConnectionOpenedListener<TDataStore> connectionOpenedListener) {
        this.connectionOpenedListeners.remove(connectionOpenedListener);
    }

    private void notifyConnectionClosedListeners(TDataStore dataStore) {
        this.connectionClosedListeners.forEach(listener -> listener.closed(dataStore));
    }

    public final void addConnectionClosedListener(ConnectionClosedListener<TDataStore> connectionClosedListener) {
        this.connectionClosedListeners.add(connectionClosedListener);
    }

    public final void removeConnectionClosedListener(ConnectionClosedListener<TDataStore> connectionClosedListener) {
        this.connectionClosedListeners.remove(connectionClosedListener);
    }
}

