/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.data.registry;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.anvilpowered.anvil.api.data.key.Key;

public interface Registry {
    public <T> T getUnsafe(Key<T> var1);

    public <T> Optional<T> get(Key<T> var1);

    default public <T> T getDefault(Key<T> key) {
        return key.getFallbackValue();
    }

    default public <T> T getOrDefault(Key<T> key) {
        return this.get(key).orElse(this.getDefault(key));
    }

    public <T> void set(Key<T> var1, T var2);

    public <T> void remove(Key<T> var1);

    public <T> void transform(Key<T> var1, BiFunction<? super Key<T>, ? super T, ? extends T> var2);

    public <T> void transform(Key<T> var1, Function<? super T, ? extends T> var2);

    public <T> void addToCollection(Key<? extends Collection<T>> var1, T var2);

    public <T> void removeFromCollection(Key<? extends Collection<T>> var1, T var2);

    public <K, T> void putInMap(Key<? extends Map<K, T>> var1, K var2, T var3);

    public <K, T> void removeFromMap(Key<? extends Map<K, T>> var1, K var2);

    public void load();

    public void whenLoaded(Runnable var1);
}

