/*
 * Decompiled with CFR 0.152.
 */
package org.anvilpowered.anvil.api.data.key;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.anvilpowered.anvil.api.data.key.Key;

public final class Keys {
    private static Map<String, Key<?>> keyMap = new HashMap();
    public static final Key<String> SERVER_NAME = new Key<String>("SERVER_NAME", "server"){};
    public static final Key<Boolean> PROXY_MODE = new Key<Boolean>("PROXY_MODE", Boolean.valueOf(false)){};
    public static final Key<String> BASE_SCAN_PACKAGE = new Key<String>("BASE_SCAN_PACKAGE", "org.anvilpowered.anvil.common.model"){};
    public static final Key<Integer> CACHE_INVALIDATION_INTERVAL_SECONDS = new Key<Integer>("CACHE_INVALIDATION_INTERVAL_SECONDS", Integer.valueOf(30)){};
    public static final Key<Integer> CACHE_INVALIDATION_TIMOUT_SECONDS = new Key<Integer>("CACHE_INVALIDATION_TIMOUT_SECONDS", Integer.valueOf(300)){};
    public static final Key<Boolean> USE_SHARED_ENVIRONMENT = new Key<Boolean>("USE_SHARED_ENVIRONMENT", Boolean.valueOf(false)){};
    public static final Key<Boolean> USE_SHARED_CREDENTIALS = new Key<Boolean>("USE_SHARED_CREDENTIALS", Boolean.valueOf(false)){};
    public static final Key<String> DATA_DIRECTORY = new Key<String>("DATA_DIRECTORY", "anvil"){};
    public static final Key<String> DATA_STORE_NAME = new Key<String>("DATA_STORE_NAME", "xodus"){};
    public static final Key<String> MONGODB_CONNECTION_STRING = new Key<String>("MONGODB_CONNECTION_STRING", "mongodb://admin:password@localhost:27017/anvil?authSource=admin"){};
    public static final Key<String> MONGODB_HOSTNAME = new Key<String>("MONGODB_HOSTNAME", "localhost"){};
    public static final Key<Integer> MONGODB_PORT = new Key<Integer>("MONGODB_PORT", Integer.valueOf(27017)){};
    public static final Key<String> MONGODB_DBNAME = new Key<String>("MONGODB_DBNAME", "anvil"){};
    public static final Key<String> MONGODB_USERNAME = new Key<String>("MONGODB_USERNAME", "admin"){};
    public static final Key<String> MONGODB_PASSWORD = new Key<String>("MONGODB_PASSWORD", "password"){};
    public static final Key<String> MONGODB_AUTH_DB = new Key<String>("MONGODB_AUTH_DB", "admin"){};
    public static final Key<Boolean> MONGODB_USE_AUTH = new Key<Boolean>("MONGODB_USE_AUTH", Boolean.valueOf(false)){};
    public static final Key<Boolean> MONGODB_USE_SRV = new Key<Boolean>("MONGODB_USE_SRV", Boolean.valueOf(false)){};
    public static final Key<Boolean> MONGODB_USE_CONNECTION_STRING = new Key<Boolean>("MONGODB_USE_CONNECTION_STRING", Boolean.valueOf(false)){};
    public static final Key<String> REDIS_HOSTNAME = new Key<String>("REDIS_HOSTNAME", "localhost"){};
    public static final Key<Integer> REDIS_PORT = new Key<Integer>("REDIS_PORT", Integer.valueOf(6379)){};
    public static final Key<String> REDIS_PASSWORD = new Key<String>("REDIS_PASSWORD", "username"){};
    public static final Key<Boolean> REDIS_USE_AUTH = new Key<Boolean>("REDIS_USE_AUTH", Boolean.valueOf(false)){};

    private Keys() {
        throw new AssertionError((Object)"**boss music** No instance for you!");
    }

    public static void registerKey(Key<?> key) {
        keyMap.put(key.getName(), key);
    }

    public static <T> Key<T> resolveUnsafe(String name) {
        return Objects.requireNonNull(keyMap.get(name));
    }

    public static <T> Optional<Key<T>> resolve(String name) {
        try {
            return Optional.ofNullable(Keys.resolveUnsafe(name));
        }
        catch (ClassCastException ignored) {
            return Optional.empty();
        }
    }

    static {
        Keys.registerKey(SERVER_NAME);
        Keys.registerKey(PROXY_MODE);
        Keys.registerKey(BASE_SCAN_PACKAGE);
        Keys.registerKey(CACHE_INVALIDATION_INTERVAL_SECONDS);
        Keys.registerKey(CACHE_INVALIDATION_TIMOUT_SECONDS);
        Keys.registerKey(USE_SHARED_ENVIRONMENT);
        Keys.registerKey(USE_SHARED_CREDENTIALS);
        Keys.registerKey(DATA_DIRECTORY);
        Keys.registerKey(DATA_STORE_NAME);
        Keys.registerKey(MONGODB_HOSTNAME);
        Keys.registerKey(MONGODB_PORT);
        Keys.registerKey(MONGODB_DBNAME);
        Keys.registerKey(MONGODB_USERNAME);
        Keys.registerKey(MONGODB_PASSWORD);
        Keys.registerKey(MONGODB_AUTH_DB);
        Keys.registerKey(MONGODB_USE_AUTH);
        Keys.registerKey(MONGODB_USE_SRV);
        Keys.registerKey(REDIS_HOSTNAME);
        Keys.registerKey(REDIS_PORT);
        Keys.registerKey(REDIS_PASSWORD);
        Keys.registerKey(REDIS_USE_AUTH);
    }
}

