/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.testsuite;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.translation.ocl.testsuite.TranslationTest;
import org.andromda.translation.ocl.testsuite.TranslationTestDiscovererException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TranslationTestDiscoverer {
    private static final Logger logger = Logger.getLogger(TranslationTestDiscoverer.class);
    private static final String TEST_PREFIX = "TranslationTest-";
    private static final List<String> IGNORED_DIRECTORIES = Arrays.asList("CVS", ".svn");
    private Map<String, TranslationTest> translationTests = new LinkedHashMap<String, TranslationTest>();
    private static TranslationTestDiscoverer instance;

    public static TranslationTestDiscoverer instance() {
        if (instance == null) {
            instance = new TranslationTestDiscoverer();
        }
        return instance;
    }

    public void discoverTests(String directory) {
        if (StringUtils.isBlank((String)directory)) {
            throw new TranslationTestDiscovererException("The 'directory'  was not specified, please specify this value with the location from which to begin the discovery of translation test files");
        }
        if (this.translationTests.isEmpty()) {
            this.discoverTests(new File(directory));
        }
    }

    private void discoverTests(File currentDirectory) {
        try {
            String[] files = currentDirectory.list();
            if (files == null || files.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no files or directories found in directory '" + currentDirectory + '\''));
                }
            } else {
                for (String filename : files) {
                    File file = new File(currentDirectory, filename);
                    if (StringUtils.trimToEmpty((String)file.getName()).startsWith(TEST_PREFIX)) {
                        URL testUrl = file.toURI().toURL();
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("found translation test --> '" + testUrl + '\''));
                        }
                        TranslationTest test = (TranslationTest)XmlObjectFactory.getInstance(TranslationTest.class).getObject(testUrl);
                        test.setUri(testUrl);
                        this.translationTests.put(test.getTranslation(), test);
                        continue;
                    }
                    if (!file.isDirectory() || IGNORED_DIRECTORIES.contains(file.getName())) continue;
                    this.discoverTests(file);
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable);
            throw new TranslationTestDiscovererException(throwable);
        }
    }

    public TranslationTest getTest(String translation) {
        return this.translationTests.get(StringUtils.trimToEmpty((String)translation));
    }

    public Map<String, TranslationTest> getTests() {
        return this.translationTests;
    }

    public void shutdown() {
        this.translationTests.clear();
        instance = null;
    }
}

