/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.andromdapp;

import java.util.ArrayList;
import java.util.List;
import org.andromda.andromdapp.AndroMDAppUtils;
import org.andromda.andromdapp.Condition;
import org.andromda.andromdapp.Conditions;
import org.apache.commons.lang.StringUtils;

public class Prompt {
    private String id;
    private boolean required = true;
    private String text;
    private final List<String> responses = new ArrayList<String>();
    private String responseType;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Conditions> preconditions = new ArrayList<Conditions>();
    private boolean setResponseAsTrue;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        if (this.text != null) {
            text.append(this.text);
        }
        if (!this.responses.isEmpty()) {
            text.append(' ').append(this.getResponsesAsString());
        }
        text.append(": ");
        return text.toString();
    }

    public void setText(String text) {
        this.text = StringUtils.trim((String)text);
    }

    public void addResponse(String response) {
        if (StringUtils.isNotBlank((String)response)) {
            this.responses.add(response.trim());
        }
    }

    public boolean isValidResponse(String response) {
        return this.responses.contains(response) || this.responses.isEmpty() && (!this.isRequired() || StringUtils.isNotBlank((String)response));
    }

    public Object getResponse(Object response) {
        return AndroMDAppUtils.convert(response, this.responseType);
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    private String getResponsesAsString() {
        StringBuilder responsesString = new StringBuilder("[");
        for (String response : this.responses) {
            responsesString.append(response).append(", ");
        }
        if (!this.responses.isEmpty()) {
            responsesString.delete(responsesString.length() - 2, responsesString.length());
        }
        responsesString.append(']');
        return responsesString.toString();
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void addPreconditions(Conditions preconditions) {
        this.preconditions.add(preconditions);
    }

    public List<Conditions> getPreconditions() {
        return this.preconditions;
    }

    public boolean isSetResponseAsTrue() {
        return this.setResponseAsTrue;
    }

    public void setSetResponseAsTrue(boolean setResponseAsBoolean) {
        this.setResponseAsTrue = setResponseAsBoolean;
    }
}

