/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.andromdapp;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.ResourceUtils;
import org.apache.commons.io.IOUtils;

public class Configuration {
    private final Properties properties = new Properties();
    private final List<String> locations = new ArrayList<String>();
    private static final String[] LOCATION_PATTERNS = new String[]{"**/*.properties"};
    private boolean overwrite;

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void addLocation(String location) {
        this.locations.add(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> allProperties = new LinkedHashMap<String, String>();
        for (String location : this.locations) {
            List resources = ResourceUtils.getDirectoryContents((URL)ResourceUtils.toURL((String)location), (boolean)true, (String[])LOCATION_PATTERNS);
            if (resources == null) continue;
            for (String path : resources) {
                URL resource = ResourceUtils.toURL((String)path);
                Properties properties = new Properties();
                InputStream stream = null;
                try {
                    stream = resource.openStream();
                    properties.load(stream);
                    this.addProperties(allProperties, properties);
                }
                catch (Exception ignore) {}
                continue;
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }
        this.addProperties(allProperties, this.properties);
        return allProperties;
    }

    protected void addProperties(Map<String, String> target, Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            target.put(propertyName, properties.getProperty(propertyName));
        }
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

