/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.andromdapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.andromda.andromdapp.AndroMDAppException;
import org.andromda.andromdapp.AndroMDAppType;
import org.andromda.andromdapp.Configuration;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ResourceFinder;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.apache.commons.lang.StringUtils;

public class AndroMDApp {
    private static final String INTERNAL_CONFIGURATION_URI = "META-INF/andromdapp/configuration.xml";
    static final String DESCRIPTOR = "andromdapp.xml";
    private static final String DESCRIPTOR_DIRECTORY = "META-INF/andromdapp";
    private final Map<String, AndroMDAppType> types = new LinkedHashMap<String, AndroMDAppType>();
    private final List<Configuration> configurations = new ArrayList<Configuration>();
    private static final String APPLICATION_TYPE = "andromdappType";

    public void run() {
        try {
            AndroMDALogger.initialize();
            URL internalConfiguration = ResourceUtils.getResource((String)INTERNAL_CONFIGURATION_URI);
            if (internalConfiguration == null) {
                throw new AndroMDAppException("No configuration could be loaded from --> 'META-INF/andromdapp/configuration.xml'");
            }
            this.addConfigurationUri(internalConfiguration.toString());
            this.initialize();
            this.chooseTypeAndRun(true);
        }
        catch (Throwable throwable) {
            if (throwable instanceof AndroMDAppException) {
                throw (AndroMDAppException)throwable;
            }
            throw new AndroMDAppException(throwable);
        }
    }

    private void initialize() throws Exception {
        URL[] descriptorDirectories = ResourceFinder.findResources((String)DESCRIPTOR_DIRECTORY);
        if (descriptorDirectories != null && descriptorDirectories.length > 0) {
            int numberOfDescriptorDirectories = descriptorDirectories.length;
            for (int ctr = 0; ctr < numberOfDescriptorDirectories; ++ctr) {
                List directoryContents = ResourceUtils.getDirectoryContents((URL)descriptorDirectories[ctr], (boolean)true, null);
                for (String uri : directoryContents) {
                    if (!uri.replaceAll(".*(\\\\+|/)", "").equals(DESCRIPTOR)) continue;
                    XmlObjectFactory factory = XmlObjectFactory.getInstance(AndroMDApp.class);
                    URL descriptorUri = ResourceUtils.toURL((String)uri);
                    AndroMDAppType andromdapp = (AndroMDAppType)factory.getObject(descriptorUri);
                    andromdapp.setResource(descriptorUri);
                    String type = andromdapp.getType();
                    AndroMDALogger.info((Object)("discovered andromdapp type --> '" + type + '\''));
                    this.types.put(type, andromdapp);
                }
            }
        }
    }

    public void addConfigurationUri(String configurationUri) {
        if (StringUtils.isNotBlank((String)configurationUri)) {
            XmlObjectFactory factory = XmlObjectFactory.getInstance(Configuration.class);
            URL configurationUrl = ResourceUtils.toURL((String)configurationUri);
            if (configurationUrl == null) {
                throw new AndroMDAppException("configuriationUri is invalid --> '" + configurationUri + '\'');
            }
            this.configurations.add((Configuration)factory.getObject(configurationUrl));
        }
    }

    public void addConfiguration(String configuration) {
        if (StringUtils.isNotBlank((String)configuration)) {
            XmlObjectFactory factory = XmlObjectFactory.getInstance(Configuration.class);
            this.configurations.add((Configuration)factory.getObject(configuration));
        }
    }

    private List<File> chooseTypeAndRun(boolean write) throws Exception {
        if (this.types.isEmpty()) {
            throw new AndroMDAppException("No 'andromdapp.xml' descriptor files could be found");
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Configuration configuration : this.configurations) {
            properties.putAll(configuration.getAllProperties());
        }
        String applicationType = (String)properties.get(APPLICATION_TYPE);
        Set<String> validTypes = this.types.keySet();
        AndroMDAppType andromdapp = this.types.get(applicationType);
        if (andromdapp == null) {
            if (this.types.size() > 1) {
                StringBuilder typesChoice = new StringBuilder("[");
                Iterator<String> iterator = validTypes.iterator();
                while (iterator.hasNext()) {
                    String type = iterator.next();
                    typesChoice.append(type);
                    if (!iterator.hasNext()) continue;
                    typesChoice.append(", ");
                }
                typesChoice.append(']');
                this.printText("Please choose the type of application to generate " + typesChoice);
                String selectedType = this.readLine();
                while (!this.types.containsKey(selectedType)) {
                    selectedType = this.readLine();
                }
                andromdapp = this.types.get(selectedType);
            } else if (!this.types.isEmpty()) {
                andromdapp = this.types.entrySet().iterator().next().getValue();
            }
        }
        andromdapp.setConfigurations(this.configurations);
        andromdapp.initialize();
        Map templateContext = andromdapp.getTemplateContext();
        XmlObjectFactory factory = XmlObjectFactory.getInstance(AndroMDApp.class);
        String contents = andromdapp.promptUser();
        andromdapp = (AndroMDAppType)factory.getObject(contents);
        andromdapp.setConfigurations(this.configurations);
        andromdapp.addToTemplateContext(templateContext);
        return andromdapp.processResources(write);
    }

    public void clean() {
        try {
            AndroMDALogger.initialize();
            this.initialize();
            List<File> list = this.chooseTypeAndRun(false);
            for (File file : list) {
                this.deleteFile(file);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AndroMDAppException) {
                throw (AndroMDAppException)throwable;
            }
            throw new AndroMDAppException(throwable);
        }
    }

    private void deleteFile(File file) throws MalformedURLException {
        File[] children;
        if (file != null && file.exists() && ((children = file.listFiles()) == null || children.length == 0)) {
            if (file.delete()) {
                AndroMDALogger.info((Object)("Removed: '" + file.toURI().toURL() + '\''));
            }
            this.deleteFile(file.getParentFile());
        }
    }

    private void printText(String text) {
        System.out.println();
        System.out.println(text);
        System.out.flush();
    }

    private String readLine() {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String inputString = null;
        try {
            inputString = input.readLine();
        }
        catch (IOException exception) {
            AndroMDALogger.info((Object)"AndroMDApp Error reading inputLine from System.in");
        }
        return StringUtils.trimToNull((String)inputString);
    }
}

