/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.andromdapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.andromda.andromdapp.AndroMDAppException;
import org.andromda.andromdapp.AndroMDAppUtils;
import org.andromda.andromdapp.Condition;
import org.andromda.andromdapp.Conditions;
import org.andromda.andromdapp.Configuration;
import org.andromda.andromdapp.Mapping;
import org.andromda.andromdapp.Prompt;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.Constants;
import org.andromda.core.common.ResourceFinder;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.templateengine.TemplateEngine;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class AndroMDAppType {
    private final Map templateContext = new LinkedHashMap();
    private static final String NAMESPACE = "andromdapp";
    private static final String TEMPORARY_MERGE_LOCATION = Constants.TEMPORARY_DIRECTORY + '/' + "andromdapp";
    private String templateEngineClass;
    private TemplateEngine templateEngine = null;
    private Map templateEngineExclusions = new LinkedHashMap();
    private static final String RESPONSE_YES = "yes";
    private static final String RESPONSE_NO = "no";
    private static final String MARGIN = "    ";
    private static final String FORWARD_SLASH = "/";
    private String type;
    private String root;
    private List configurations;
    private final List prompts = new ArrayList();
    private List resourceLocations = new ArrayList();
    private List directories = new ArrayList();
    private List outputConditions = new ArrayList();
    private String[] templateExtensions;
    private String instructions;
    URL resource;
    private List mappings = new ArrayList();

    protected void initialize() throws Exception {
        if (this.configurations != null) {
            Iterator iterator = this.configurations.iterator();
            while (iterator.hasNext()) {
                this.templateContext.putAll(((Configuration)iterator.next()).getAllProperties());
            }
        }
    }

    protected String promptUser() throws Exception {
        for (Prompt prompt : this.getPrompts()) {
            String id = prompt.getId();
            boolean validPreconditions = true;
            block1: for (Conditions preconditions : prompt.getPreconditions()) {
                String conditionsType = preconditions.getType();
                for (Condition precondition : preconditions.getConditions()) {
                    validPreconditions = precondition.evaluate(this.templateContext.get(precondition.getId()));
                    if (!("and".equals(conditionsType) ? !validPreconditions : validPreconditions)) continue;
                    continue block1;
                }
            }
            if (!validPreconditions) continue;
            Object response = this.templateContext.get(id);
            if (response == null) {
                while (!prompt.isValidResponse(ObjectUtils.toString(response = this.promptForInput(prompt)))) {
                }
            }
            this.setConditionalProperties(prompt.getConditions(), response);
            if (prompt.isSetResponseAsTrue()) {
                this.templateContext.put(response, Boolean.TRUE);
            }
            this.templateContext.put(id, prompt.getResponse(response));
        }
        return this.getTemplateEngine().getEvaluatedExpression(ResourceUtils.getContents((URL)this.resource), this.templateContext);
    }

    private String promptForInput(Prompt prompt) {
        this.printPromptText(prompt.getText());
        String input = this.readLine();
        return input;
    }

    private void setConditionalProperties(List conditions, Object value) {
        for (Condition condition : conditions) {
            String notEqualCondition;
            String equalCondition = condition.getEqual();
            if (equalCondition != null && equalCondition.equals(value)) {
                this.setProperties(condition);
            }
            if ((notEqualCondition = condition.getNotEqual()) == null || notEqualCondition.equals(value)) continue;
            this.setProperties(condition);
        }
    }

    private void setProperties(Condition condition) {
        if (condition != null) {
            Map values = condition.getProperties();
            for (String id : values.keySet()) {
                this.templateContext.put(id, values.get(id));
            }
        }
    }

    public void setTemplateEngineClass(String templateEngineClass) {
        this.templateEngineClass = templateEngineClass;
    }

    private TemplateEngine getTemplateEngine() throws Exception {
        if (this.templateEngine == null) {
            this.templateEngine = (TemplateEngine)ComponentContainer.instance().newComponent(this.templateEngineClass, TemplateEngine.class);
            this.getTemplateEngine().setMergeLocation(TEMPORARY_MERGE_LOCATION);
            this.getTemplateEngine().initialize(NAMESPACE);
        }
        return this.templateEngine;
    }

    public void addTemplateEngineExclusion(String path, String patterns) {
        this.templateEngineExclusions.put(path, AndroMDAppUtils.stringToArray(patterns));
    }

    final Map getTemplateEngineExclusions() {
        return this.templateEngineExclusions;
    }

    protected List processResources(boolean write) throws Exception {
        ArrayList<File> processedResources = new ArrayList<File>();
        File rootDirectory = this.verifyRootDirectory(new File(this.getRoot()));
        String bannerStart = write ? "G e n e r a t i n g" : "R e m o v i n g";
        this.printLine();
        this.printText(MARGIN + bannerStart + "   A n d r o M D A   P o w e r e d   A p p l i c a t i o n");
        this.printLine();
        rootDirectory.mkdirs();
        LinkedHashMap locations = new LinkedHashMap();
        for (String location : this.resourceLocations) {
            URL[] resourceDirectories = ResourceFinder.findResources((String)location);
            if (resourceDirectories == null) continue;
            for (URL resourceDirectory : resourceDirectories) {
                List contents = ResourceUtils.getDirectoryContents((URL)resourceDirectory, (boolean)false, null);
                LinkedHashSet<String> newContents = new LinkedHashSet<String>();
                locations.put(location, newContents);
                ListIterator contentsIterator = contents.listIterator();
                while (contentsIterator.hasNext()) {
                    String path = (String)contentsIterator.next();
                    if (path.endsWith(FORWARD_SLASH)) continue;
                    boolean hasNewPath = false;
                    for (Mapping mapping : this.mappings) {
                        URL absolutePath;
                        String newPath = mapping.getMatch(path);
                        if (newPath == null || newPath.length() <= 0 || (absolutePath = ResourceUtils.getResource((String)path)) == null) continue;
                        newPath = this.getTemplateEngine().getEvaluatedExpression(newPath, this.templateContext);
                        ResourceWriter.instance().writeUrlToFile(absolutePath, ResourceUtils.normalizePath((String)(TEMPORARY_MERGE_LOCATION + '/' + newPath)));
                        newContents.add(newPath);
                        hasNewPath = true;
                    }
                    if (hasNewPath) continue;
                    newContents.add(path);
                }
            }
        }
        for (String location : locations.keySet()) {
            Collection contents = (Collection)locations.get(location);
            if (contents == null) continue;
            for (String path : contents) {
                File outputFile;
                String projectRelativePath = StringUtils.replace((String)path, (String)location, (String)"");
                if (!this.isWriteable(projectRelativePath)) continue;
                if (this.isValidTemplate(path)) {
                    outputFile = new File(rootDirectory.getAbsolutePath(), this.trimTemplateExtension(projectRelativePath));
                    if (write) {
                        StringWriter writer = new StringWriter();
                        try {
                            this.getTemplateEngine().processTemplate(path, this.templateContext, (Writer)writer);
                        }
                        catch (Throwable throwable) {
                            throw new AndroMDAppException("An error occured while processing template --> '" + path + "' with template context '" + this.templateContext + "'", throwable);
                        }
                        writer.flush();
                        this.printText("    Output: '" + outputFile.toURI().toURL() + "'");
                        ResourceWriter.instance().writeStringToFile(writer.toString(), outputFile);
                    }
                    processedResources.add(outputFile);
                    continue;
                }
                if (path.endsWith(FORWARD_SLASH)) continue;
                outputFile = new File(rootDirectory.getAbsolutePath(), projectRelativePath);
                URL resource = ResourceUtils.toURL((String)ResourceUtils.normalizePath((String)(TEMPORARY_MERGE_LOCATION + '/' + path)));
                if (resource == null) {
                    resource = ClassUtils.getClassLoader().getResource(path);
                }
                if (resource == null) continue;
                if (write) {
                    ResourceWriter.instance().writeUrlToFile(resource, outputFile.toString());
                    this.printText("    Output: '" + outputFile.toURI().toURL() + "'");
                }
                processedResources.add(outputFile);
            }
        }
        Iterator directoryIterator = this.directories.iterator();
        while (directoryIterator.hasNext()) {
            String directoryPath = ((String)directoryIterator.next()).trim();
            File directory = new File(rootDirectory, directoryPath);
            if (!this.isWriteable(directoryPath)) continue;
            directory.mkdirs();
            this.printText("    Output: '" + directory.toURI().toURL() + "'");
        }
        if (write) {
            this.printLine();
            this.printText("    New application generated to --> '" + rootDirectory.toURI().toURL() + "'");
            if (this.instructions != null && this.instructions.trim().length() > 0) {
                File instructions = new File(rootDirectory.getAbsolutePath(), this.instructions);
                if (!instructions.exists()) {
                    throw new AndroMDAppException("No instructions are available at --> '" + instructions + "', please make sure you have the correct instructions defined in your descriptor --> '" + this.resource + "'");
                }
                this.printText("    Instructions for your new application --> '" + instructions.toURI().toURL() + "'");
            }
            this.printLine();
        }
        return processedResources;
    }

    private boolean isWriteable(String path) {
        if ((path = path.replaceAll("\\\\+", FORWARD_SLASH)).startsWith(FORWARD_SLASH)) {
            path = path.substring(1, path.length());
        }
        Boolean writable = null;
        LinkedHashMap<String, Boolean> evaluatedPaths = new LinkedHashMap<String, Boolean>();
        for (Conditions conditions : this.outputConditions) {
            Map outputPaths = conditions.getOutputPaths();
            String conditionsType = conditions.getType();
            int ctr = 0;
            for (String outputPath : outputPaths.keySet()) {
                writable = (Boolean)evaluatedPaths.get(path);
                if (writable == null) {
                    String[] patterns;
                    if (path.startsWith(outputPath) && ResourceUtils.matchesAtLeastOnePattern((String)path, (String[])(patterns = (String[])outputPaths.get(outputPath)))) {
                        for (Condition condition : conditions.getConditions()) {
                            String id = condition.getId();
                            if (id == null || id.trim().length() <= 0) continue;
                            boolean result = condition.evaluate(this.templateContext.get(id));
                            writable = result;
                            if ((!"and".equals(conditionsType) || result) && (!"or".equals(conditionsType) || !result)) continue;
                            break;
                        }
                    }
                    if (writable != null) {
                        evaluatedPaths.put(path, writable);
                    }
                }
                ++ctr;
            }
        }
        if (writable == null) {
            writable = Boolean.TRUE;
        }
        return writable;
    }

    private boolean isValidTemplate(String path) {
        String[] patterns;
        String exclusionPath;
        boolean exclude = false;
        Map exclusions = this.getTemplateEngineExclusions();
        Iterator pathIterator = exclusions.keySet().iterator();
        while (!(!pathIterator.hasNext() || path.startsWith(exclusionPath = (String)pathIterator.next()) && (exclude = ResourceUtils.matchesAtLeastOnePattern((String)exclusionPath, (String[])(patterns = (String[])exclusions.get(exclusionPath)))))) {
        }
        boolean validTemplate = false;
        if (!exclude && this.templateExtensions != null) {
            int numberOfExtensions = this.templateExtensions.length;
            for (int ctr = 0; ctr < numberOfExtensions; ++ctr) {
                String extension = '.' + this.templateExtensions[ctr];
                boolean bl = validTemplate = extension != null && path.endsWith(extension);
                if (validTemplate) break;
            }
        }
        return validTemplate;
    }

    private String trimTemplateExtension(String path) {
        if (this.templateExtensions != null) {
            int numberOfExtensions = this.templateExtensions.length;
            for (int ctr = 0; ctr < numberOfExtensions; ++ctr) {
                String extension = '.' + this.templateExtensions[ctr];
                if (extension == null || !path.endsWith(extension)) continue;
                path = path.substring(0, path.length() - extension.length());
                break;
            }
        }
        return path;
    }

    private void printLine() {
        this.printText("-------------------------------------------------------------------------------------");
    }

    private File verifyRootDirectory(File rootDirectory) {
        File applicationRoot = rootDirectory;
        if (rootDirectory.exists() && !this.isOvewrite()) {
            this.printPromptText("'" + rootDirectory.getAbsolutePath() + "' already exists, would you like to try a new name? [yes, no]: ");
            String response = this.readLine();
            while (!RESPONSE_YES.equals(response) && !RESPONSE_NO.equals(response)) {
                response = this.readLine();
            }
            if (RESPONSE_YES.equals(response)) {
                String rootName;
                this.printPromptText("Please enter the name for your application root directory: ");
                while ((rootName = this.readLine()) == null || rootName.trim().length() == 0) {
                }
                applicationRoot = this.verifyRootDirectory(new File(rootName));
            }
        }
        return applicationRoot;
    }

    private boolean isOvewrite() {
        boolean overwrite;
        block1: {
            Configuration configuration;
            overwrite = false;
            if (this.configurations == null) break block1;
            Iterator iterator = this.configurations.iterator();
            while (iterator.hasNext() && !(overwrite = (configuration = (Configuration)iterator.next()).isOverwrite())) {
            }
        }
        return overwrite;
    }

    private void printPromptText(String text) {
        System.out.println();
        this.printText(text);
    }

    private void printText(String text) {
        System.out.println(text);
        System.out.flush();
    }

    private String readLine() {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String inputString = null;
        try {
            inputString = input.readLine();
        }
        catch (IOException exception) {
            inputString = null;
        }
        return inputString == null || inputString.trim().length() == 0 ? null : inputString;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    final void setConfigurations(List configurations) {
        this.configurations = configurations;
    }

    public void addPrompt(Prompt prompt) {
        this.prompts.add(prompt);
    }

    public List getPrompts() {
        return this.prompts;
    }

    public void addResourceLocation(String resourceLocation) {
        this.resourceLocations.add(resourceLocation);
    }

    public void addDirectory(String directory) {
        this.directories.add(directory);
    }

    public void addOutputConditions(Conditions outputConditions) {
        this.outputConditions.add(outputConditions);
    }

    public void setTemplateExtensions(String templateExtensions) {
        this.templateExtensions = AndroMDAppUtils.stringToArray(templateExtensions);
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String toString() {
        return super.toString() + "[" + this.getType() + "]";
    }

    final void setResource(URL resource) {
        this.resource = resource;
    }

    final URL getResource() {
        return this.resource;
    }

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }

    final void addToTemplateContext(Map map) {
        this.templateContext.putAll(map);
    }

    final Map getTemplateContext() {
        return this.templateContext;
    }

    public void addTemplateObject(String name, String className) {
        this.templateContext.put(name, ClassUtils.newInstance((String)className));
    }
}

