/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.experiment.task;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.time.ExecutionTimeRecorderIgnore;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.arguments.TaskArguments;
import org.anchoranalysis.experiment.bean.log.LoggingDestination;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.task.ExperimentFeedbackContext;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.ParametersUnbound;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.bean.OutputManager;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.bean.rules.NoneExcept;
import org.anchoranalysis.io.output.bean.rules.OutputEnabledRules;
import org.anchoranalysis.io.output.bean.rules.Permissive;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.test.experiment.task.CompareHelper;
import org.anchoranalysis.test.image.io.BeanInstanceMapFixture;
import org.anchoranalysis.test.image.io.OutputterFixture;
import org.anchoranalysis.test.io.output.OutputManagerFixture;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ExecuteTaskHelper {
    private final Optional<String> specificOutput;
    private final TaskArguments taskArguments;
    private final boolean copyNonIdentical;

    public ExecuteTaskHelper() {
        this(false);
    }

    public ExecuteTaskHelper(boolean copyNonIdentical) {
        this.specificOutput = Optional.empty();
        this.taskArguments = new TaskArguments();
        this.copyNonIdentical = copyNonIdentical;
    }

    public ExecuteTaskHelper(Optional<String> specificOutput, TaskArguments taskArguments, boolean copyNonIdentical) {
        this.specificOutput = specificOutput;
        this.taskArguments = taskArguments;
        this.copyNonIdentical = copyNonIdentical;
    }

    public <T extends InputFromManager, S, V extends Task<T, S>> void assertExpectedTaskOutputs(T input, V task, Path pathDirectoryOutput, String pathDirectorySaved, Iterable<String> pathsFileToCompare) throws OperationFailedException {
        this.assertExpectedTaskOutputs(Arrays.asList(input), task, pathDirectoryOutput, pathDirectorySaved, pathsFileToCompare);
    }

    public <T extends InputFromManager, S, V extends Task<T, S>> void assertExpectedTaskOutputs(List<T> inputs, V task, Path pathDirectoryOutput, String pathDirectorySaved, Iterable<String> pathsFileToCompare) throws OperationFailedException {
        boolean successful = ExecuteTaskHelper.executeTaskOnInputs(inputs, task, this.taskArguments, pathDirectoryOutput, this.specificOutput);
        Assertions.assertTrue((boolean)successful, (String)"Sucessful execution of task");
        CompareHelper.assertDirectoriesIdentical(pathDirectoryOutput, pathDirectorySaved, pathsFileToCompare, this.copyNonIdentical);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends InputFromManager, S, V extends Task<T, S>> boolean executeTaskOnInputs(List<T> inputs, V task, TaskArguments taskArguments, Path pathForOutputs, Optional<String> specificOutputEnabled) throws OperationFailedException {
        boolean bl;
        BeanInstanceMapFixture.check(task);
        OutputEnabledRules outputEnabled = ExecuteTaskHelper.createOutputRules(specificOutputEnabled);
        OutputManager outputManager = OutputManagerFixture.createOutputManager(Optional.of(pathForOutputs), Optional.of(outputEnabled));
        Outputter outputter = OutputterFixture.outputter((OutputManager)outputManager, (OutputEnabledRules)outputEnabled);
        StatefulMessageLogger logger = ExecuteTaskHelper.createStatefulLogReporter();
        ParametersExperiment parametersExperiment = ExecuteTaskHelper.createParametersExperiment(outputter.getChecked(), outputManager.getPrefixer(), taskArguments, logger);
        ConcurrencyPlan concurrencyPlan = ConcurrencyPlan.singleCPUProcessor((int)0);
        Object sharedState = task.beforeAnyJobIsExecuted(outputter, concurrencyPlan, inputs, parametersExperiment);
        try {
            boolean successful = true;
            for (InputFromManager input : inputs) {
                successful = successful && task.executeJob(new ParametersUnbound(parametersExperiment, (Object)input, sharedState, false));
            }
            bl = successful;
        }
        catch (Throwable throwable) {
            try {
                task.afterAllJobsAreExecuted(sharedState, (InputOutputContext)parametersExperiment.getContext());
                throw throwable;
            }
            catch (ExperimentExecutionException | JobExecutionException | BindFailedException exc) {
                throw new OperationFailedException(exc);
            }
        }
        task.afterAllJobsAreExecuted(sharedState, (InputOutputContext)parametersExperiment.getContext());
        return bl;
    }

    private static OutputEnabledRules createOutputRules(Optional<String> specificOutputEnabled) {
        if (specificOutputEnabled.isPresent()) {
            return new NoneExcept(specificOutputEnabled.get());
        }
        return new Permissive();
    }

    private static ParametersExperiment createParametersExperiment(OutputterChecked outputter, PathPrefixer prefixer, TaskArguments taskArguments, StatefulMessageLogger logger) {
        ExperimentFeedbackContext context = new ExperimentFeedbackContext(logger, false, ExecutionTimeRecorderIgnore.instance());
        ParametersExperiment parameters = new ParametersExperiment(new ExecutionArguments(Paths.get(".", new String[0]), taskArguments), "arbitraryExperimentName", outputter, prefixer, context);
        parameters.setLoggerTaskCreator(ExecuteTaskHelper.createLogReporterBean());
        return parameters;
    }

    private static LoggingDestination createLogReporterBean() {
        LoggingDestination logger = (LoggingDestination)Mockito.mock(LoggingDestination.class);
        Mockito.when((Object)logger.create((OutputterChecked)ArgumentMatchers.any(), (ErrorReporter)ArgumentMatchers.any(), (ExecutionArguments)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)ExecuteTaskHelper.createStatefulLogReporter());
        Mockito.when((Object)logger.createWithLogFallback((OutputterChecked)ArgumentMatchers.any(), (MessageLogger)ArgumentMatchers.any(), (ExecutionArguments)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)ExecuteTaskHelper.createStatefulLogReporter());
        return logger;
    }

    private static StatefulMessageLogger createStatefulLogReporter() {
        return (StatefulMessageLogger)Mockito.mock(StatefulMessageLogger.class);
    }
}

