/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.test.experiment;

import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.log.Logger;

public class BeanTestChecker {
    public static <T extends AnchorBean<?>> T check(T bean) {
        try {
            bean.checkMisconfigured(new BeanInstanceMap());
        }
        catch (BeanMisconfiguredException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
        return bean;
    }

    public static <T extends InitializableBean<?, P>, P extends BeanInitialization> T checkAndInit(T bean, P initialization, Logger logger) {
        BeanTestChecker.check(bean);
        try {
            bean.initializeRecursive(initialization, logger);
        }
        catch (InitializeException e) {
            throw new AnchorFriendlyRuntimeException((Throwable)e);
        }
        return bean;
    }

    @Generated
    private BeanTestChecker() {
    }
}

