/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.scale;

import lombok.Generated;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;
import org.anchoranalysis.spatial.scale.Scaler;

public class RelativeScaleCalculator {
    public static ScaleFactor relativeScale(Extent source, Extent target, boolean preserveAspectRatio) {
        if (preserveAspectRatio) {
            return RelativeScaleCalculator.relativeScalePreserveAspectRatio(source, target);
        }
        return RelativeScaleCalculator.relativeScale(source, target);
    }

    public static ScaleFactor relativeScalePreserveAspectRatio(Extent source, Extent target) {
        ScaleFactor withoutPreserving = RelativeScaleCalculator.relativeScale(source, target);
        double minDimension = withoutPreserving.minimumDimension();
        return new ScaleFactor(minDimension, minDimension);
    }

    public static ScaleFactor relativeScale(Extent source, Extent target) {
        return new ScaleFactor(Scaler.deriveScalingFactor(target.x(), source.x()), Scaler.deriveScalingFactor(target.y(), source.y()));
    }

    @Generated
    private RelativeScaleCalculator() {
    }
}

