/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.rtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.rtree.BoundingBoxRTree;

public class SpatiallySeparate<T> {
    private Function<T, BoundingBox> extractBoundingBox;

    public List<Set<T>> separate(Collection<T> elements) {
        ArrayList<Set<T>> out = new ArrayList<Set<T>>();
        BoundingBoxRTree<T> tree = this.createTree(elements);
        while (!tree.isEmpty()) {
            HashSet cluster = new HashSet();
            this.findArbitrarySpatiallyConnected(tree, cluster);
            out.add(cluster);
        }
        return out;
    }

    private BoundingBoxRTree<T> createTree(Collection<T> elements) {
        BoundingBoxRTree<T> tree = new BoundingBoxRTree<T>(elements.size());
        for (T element : elements) {
            tree.add(this.extractBoundingBox.apply(element), element);
        }
        return tree;
    }

    private void findArbitrarySpatiallyConnected(BoundingBoxRTree<T> tree, Set<T> out) {
        LinkedList<T> intersecting = new LinkedList<T>();
        intersecting.add(tree.arbitraryElement());
        while (!intersecting.isEmpty()) {
            Object current = intersecting.pop();
            if (out.contains(current)) continue;
            out.add(current);
            BoundingBox boxCurrent = this.extractBoundingBox.apply(current);
            for (T neighbor : tree.intersectsWith(boxCurrent)) {
                if (out.contains(neighbor)) continue;
                intersecting.add(neighbor);
            }
            tree.remove(boxCurrent, current);
        }
    }

    @Generated
    public SpatiallySeparate(Function<T, BoundingBox> extractBoundingBox) {
        this.extractBoundingBox = extractBoundingBox;
    }
}

