/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.rtree;

import com.github.davidmoten.rtreemulti.Entry;
import com.github.davidmoten.rtreemulti.geometry.Geometry;
import com.github.davidmoten.rtreemulti.geometry.Point;
import com.github.davidmoten.rtreemulti.geometry.Rectangle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class RTree<T> {
    private com.github.davidmoten.rtreemulti.RTree<T, Geometry> tree;

    protected RTree(int numberDimensions) {
        this.tree = com.github.davidmoten.rtreemulti.RTree.dimensions((int)numberDimensions).create();
    }

    protected RTree(int numberDimensions, int maxNumberEntries) {
        int maxChildren = Math.max(maxNumberEntries, 3);
        this.tree = com.github.davidmoten.rtreemulti.RTree.maxChildren((int)maxChildren).dimensions(numberDimensions).create();
    }

    public int size() {
        return this.tree.size();
    }

    public Set<T> asSet() {
        return this.toSet(this.tree.entries());
    }

    public T arbitraryElement() {
        return (T)((Entry)this.tree.entries().iterator().next()).value();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    protected void add(Rectangle rectangle, T payload) {
        this.tree = this.tree.add(payload, (Geometry)rectangle);
    }

    protected Stream<T> containsStream(Point point) {
        return this.toStream(this.tree.search(point));
    }

    protected Stream<T> intersectsWithStream(Rectangle rectangle) {
        return this.toStream(this.tree.search(rectangle));
    }

    protected void remove(Rectangle rectangle, T payload) {
        this.tree = this.tree.delete(payload, (Geometry)rectangle, true);
    }

    private Set<T> toSet(Iterable<Entry<T, Geometry>> entries) {
        return this.toStream(entries).collect(Collectors.toSet());
    }

    private Stream<T> toStream(Iterable<Entry<T, Geometry>> entries) {
        return StreamSupport.stream(entries.spliterator(), false).map(Entry::value);
    }
}

