/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.rtree;

import com.github.davidmoten.rtreemulti.geometry.Point;
import com.github.davidmoten.rtreemulti.geometry.Rectangle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.spatial.rtree.RTree;

public class IntervalRTree<T>
extends RTree<T> {
    private static final int NUMBER_DIMENSIONS = 2;

    public IntervalRTree() {
        super(2);
    }

    public IntervalRTree(int maxNumberEntries) {
        super(2, maxNumberEntries);
    }

    public void add(double min, double max, T payload) {
        super.add(IntervalRTree.asRectangle(min, max), payload);
    }

    public Set<T> contains(double point) {
        return this.containsStream(point).collect(Collectors.toSet());
    }

    public Stream<T> containsStream(double point) {
        Point pointToSearch = Point.create((double[])new double[]{point, point});
        return super.containsStream(pointToSearch);
    }

    public Set<T> intersectsWith(double min, double max) {
        return this.intersectsWithStream(min, max).collect(Collectors.toSet());
    }

    public Stream<T> intersectsWithStream(double min, double max) {
        return super.intersectsWithStream(IntervalRTree.asRectangle(min, max));
    }

    public void remove(double min, double max, T payload) {
        super.remove(IntervalRTree.asRectangle(min, max), payload);
    }

    private static Rectangle asRectangle(double min, double max) {
        return Rectangle.create((double[])new double[]{min, min, max, max});
    }
}

