/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.io.Serializable;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.spatial.axis.Axis;

public abstract class Tuple3f
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float z = 0.0f;

    public final float valueByDimension(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        assert (false);
        throw new AnchorFriendlyRuntimeException("the index for axis must be: 0 or 1 or 2");
    }

    public final float valueByDimension(int dimensionIndex) {
        return switch (dimensionIndex) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new AnchorFriendlyRuntimeException("axis must be: x or y or z");
        };
    }

    public final void setValueByDimension(int dimensionIndex, float valueToAssign) {
        switch (dimensionIndex) {
            case 0: {
                this.x = valueToAssign;
                break;
            }
            case 1: {
                this.y = valueToAssign;
                break;
            }
            case 2: {
                this.z = valueToAssign;
                break;
            }
            default: {
                throw new AnchorFriendlyRuntimeException("axis must be: x or y or z");
            }
        }
    }

    public String toString() {
        return String.format("[%f,%f,%f]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    @Generated
    public Tuple3f() {
    }

    @Generated
    public float x() {
        return this.x;
    }

    @Generated
    public float y() {
        return this.y;
    }

    @Generated
    public float z() {
        return this.z;
    }

    @Generated
    public Tuple3f x(float x) {
        this.x = x;
        return this;
    }

    @Generated
    public Tuple3f y(float y) {
        this.y = y;
        return this;
    }

    @Generated
    public Tuple3f z(float z) {
        this.z = z;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple3f)) {
            return false;
        }
        Tuple3f other = (Tuple3f)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.x(), other.x()) != 0) {
            return false;
        }
        if (Float.compare(this.y(), other.y()) != 0) {
            return false;
        }
        return Float.compare(this.z(), other.z()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tuple3f;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.x());
        result = result * 59 + Float.floatToIntBits(this.y());
        result = result * 59 + Float.floatToIntBits(this.z());
        return result;
    }
}

