/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import org.anchoranalysis.math.arithmetic.RunningSum;
import org.anchoranalysis.math.arithmetic.RunningSumCollection;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;

public final class RunningSumPoint {
    private final RunningSumCollection delegate = new RunningSumCollection(3);

    public void increment(Point2i point) {
        this.forDim(0).increment((double)point.x());
        this.forDim(1).increment((double)point.y());
    }

    public void increment(Point2d point) {
        this.forDim(0).increment(point.x());
        this.forDim(1).increment(point.y());
    }

    public void increment(Point3i point) {
        this.forDim(0).increment((double)point.x());
        this.forDim(1).increment((double)point.y());
        this.forDim(2).increment((double)point.z());
    }

    public void increment(Point3d point) {
        this.forDim(0).increment(point.x());
        this.forDim(1).increment(point.y());
        this.forDim(2).increment(point.z());
    }

    public Point3d mean() {
        return new Point3d(this.forDim(0).mean(), this.forDim(1).mean(), this.forDim(2).mean());
    }

    public Point2d meanXY() {
        return new Point2d(this.forDim(0).mean(), this.forDim(1).mean());
    }

    public long countXY() {
        return this.forDim(0).getCount();
    }

    public long countZ() {
        return this.forDim(2).getCount();
    }

    private RunningSum forDim(int dimensionIndex) {
        return this.delegate.get(dimensionIndex);
    }
}

