/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point2f;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class PointConverter {
    public static Point2i intFromDoubleFloor(Point2d point) {
        return new Point2i((int)point.x(), (int)point.y());
    }

    public static Point3i intFromDoubleFloor(Point3d point) {
        return new Point3i((int)point.x(), (int)point.y(), (int)point.z());
    }

    public static Point3i intFromDoubleCeil(Point3d point) {
        return new Point3i((int)Math.ceil(point.x()), (int)Math.ceil(point.y()), (int)Math.ceil(point.z()));
    }

    public static Point3i convertTo3i(Point2i point) {
        return new Point3i(point.x(), point.y(), 0);
    }

    public static Point3i convertTo3i(Point2i point, int z) {
        return new Point3i(point.x(), point.y(), z);
    }

    public static Point3d convertTo3d(Point2d point) {
        return new Point3d(point.x(), point.y(), 0.0);
    }

    public static Point2d doubleFromFloat(Point2f point) {
        return new Point2d(point.x(), point.y());
    }

    public static Point3d double3DFromFloat(Point2f point) {
        return new Point3d(point.x(), point.y(), 0.0);
    }

    public static Point3d doubleFromFloat(Point3f point) {
        return new Point3d(point.x(), point.y(), point.z());
    }

    public static Point3d doubleFromInt(Point2i point) {
        return new Point3d(point.x(), point.y(), 0.0);
    }

    public static Point3d doubleFromInt(ReadableTuple3i point) {
        return new Point3d(point.x(), point.y(), point.z());
    }

    public static Point3f floatFromInt(Point2i point) {
        return new Point3f(point.x(), point.y(), 0.0f);
    }

    public static Point2f floatFromDouble(Point2d point) {
        return new Point2f((float)point.x(), (float)point.y());
    }

    public static Point3f floatFromDouble(Point3d point) {
        return new Point3f((float)point.x(), (float)point.y(), (float)point.z());
    }

    public static Point3f floatFromInt(ReadableTuple3i point) {
        return new Point3f(point.x(), point.y(), point.z());
    }

    public static Point3f floatFromIntDropZ(ReadableTuple3i point) {
        return new Point3f(point.x(), point.y(), 0.0f);
    }

    public static Point3i intFromFloat(Point3f point, boolean round) {
        if (round) {
            return new Point3i(PointConverter.roundInt(point.x()), PointConverter.roundInt(point.y()), PointConverter.roundInt(point.z()));
        }
        return new Point3i(PointConverter.ceilInt(point.x()), PointConverter.ceilInt(point.y()), PointConverter.ceilInt(point.z()));
    }

    public static Point3i intFromDouble(Point3d point, boolean round) {
        if (round) {
            return new Point3i(PointConverter.roundInt(point.x()), PointConverter.roundInt(point.y()), PointConverter.roundInt(point.z()));
        }
        return new Point3i(PointConverter.ceilInt(point.x()), PointConverter.ceilInt(point.y()), PointConverter.ceilInt(point.z()));
    }

    public static List<Point3f> convert3iTo3f(List<Point3i> points) {
        return PointConverter.convert(points, PointConverter::floatFromInt);
    }

    public static List<Point3f> convert3dTo3f(List<Point3d> points) {
        return PointConverter.convert(points, PointConverter::floatFromDouble);
    }

    public static List<Point3f> convert2iTo3f(List<Point2i> points) {
        return PointConverter.convert(points, PointConverter::floatFromInt);
    }

    public static List<Point3d> convert2iTo3d(List<Point2i> points) {
        return PointConverter.convert(points, PointConverter::doubleFromInt);
    }

    public static List<Point3d> convert3fTo3d(List<Point3f> points) {
        return PointConverter.convert(points, PointConverter::doubleFromFloat);
    }

    public static List<Point3i> convert3i(List<Point3f> points, boolean round) {
        return PointConverter.convert(points, point -> PointConverter.intFromFloat(point, round));
    }

    public static List<Point3i> convert3i(List<Point3d> points) {
        return PointConverter.convert(points, PointConverter::intFromDoubleFloor);
    }

    private static <S, T> List<S> convert(List<T> points, Function<T, S> mapFunction) {
        return FunctionalList.mapToList(points, mapFunction);
    }

    private static int roundInt(double value) {
        return (int)Math.round(value);
    }

    private static int ceilInt(double value) {
        return (int)Math.ceil(value);
    }

    @Generated
    private PointConverter() {
    }
}

