/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.spatial.point;

import java.util.function.IntBinaryOperator;
import lombok.Generated;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3i;

public final class Point3i
extends Tuple3i {
    private static final long serialVersionUID = 1L;
    public static final Point3i ORIGIN = new Point3i();

    public Point3i() {
    }

    public Point3i(int valueForAllDimensions) {
        this(valueForAllDimensions, valueForAllDimensions, valueForAllDimensions);
    }

    public Point3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3i(ReadableTuple3i point) {
        this.x = point.x();
        this.y = point.y();
        this.z = point.z();
    }

    public double distance(Point3i point) {
        return Math.sqrt(this.distanceSquared(point));
    }

    public int distanceSquared(Point3i point) {
        int sx = this.x - point.x;
        int sy = this.y - point.y;
        int sz = this.z - point.z;
        return sx * sx + sy * sy + sz * sz;
    }

    public double distanceSquared(Point3d point) {
        double sx = -point.x + (double)this.x;
        double sy = -point.y + (double)this.y;
        double sz = -point.z + (double)this.z;
        return sx * sx + sy * sy + sz * sz;
    }

    public int distanceMax(Point3i point) {
        int sx = Math.abs(this.x - point.x);
        int sy = Math.abs(this.y - point.y);
        int sz = Math.abs(this.z - point.z);
        return Math.max(sx, Math.max(sy, sz));
    }

    @Override
    public Point3i duplicateChangeZ(int zValueToAssign) {
        return new Point3i(this.x, this.y, zValueToAssign);
    }

    public static Point3i immutableAdd(ReadableTuple3i tuple1, ReadableTuple3i tuple2) {
        Point3i pointCopy = new Point3i(tuple1);
        pointCopy.add(tuple2);
        return pointCopy;
    }

    public static Point3i immutableAdd(ReadableTuple3i tuple1, ReadableTuple3i tuple2, ReadableTuple3i tuple3) {
        Point3i pointCopy = new Point3i(tuple1);
        pointCopy.add(tuple2);
        pointCopy.add(tuple3);
        return pointCopy;
    }

    public static Point3i immutableAdd(ReadableTuple3i tuple, int x, int y, int z) {
        Point3i pointCopy = new Point3i(tuple);
        pointCopy.incrementX(x);
        pointCopy.incrementY(y);
        pointCopy.incrementZ(z);
        return pointCopy;
    }

    public static Point3i immutableSubtract(ReadableTuple3i tuple, ReadableTuple3i toSubtract) {
        Point3i pointCopy = new Point3i(tuple);
        pointCopy.subtract(toSubtract);
        return pointCopy;
    }

    public static Point3i immutableScale(ReadableTuple3i point, int factor) {
        Point3i pointCopy = new Point3i(point);
        pointCopy.scale(factor);
        return pointCopy;
    }

    public static Point3i elementwiseOperation(ReadableTuple3i tuple1, ReadableTuple3i tuple2, IntBinaryOperator operator) {
        return new Point3i(operator.applyAsInt(tuple1.x(), tuple2.x()), operator.applyAsInt(tuple1.y(), tuple2.y()), operator.applyAsInt(tuple1.z(), tuple2.z()));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3i)) {
            return false;
        }
        Point3i other = (Point3i)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point3i;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

